<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_CategoryView")) {
    /**
     * Class WpBookingPro_CategoryView
     */
    class WpBookingPro_CategoryView extends WooBookingView
    {
        /**
         * @var
         */
        public $list;
        /**
         * @var
         */
        public $filterForm;

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function display($tpl = null)
        {
            $input = Factory::getInput();
            switch ($tpl) {
                case "config_list":
                    $modelBlock = WoobookingModel::getInstance('block');
                    $id = $input->getInt('id', 0);
                    $this->item = $modelBlock->getItem($id);
                    $this->form = $modelBlock->getFormConfigBlock('category', $tpl);
                    break;
                case "form":
                    $id = $input->getInt('id', 0);
                    $this->item = $modelEvent->getItem($id);
                    $this->form = $modelEvent->getForm();
                    break;
                case "config_training":
                    break;
                case "list":
                    $modeServices = WoobookingModel::getInstance('categories');
                    $this->list = $modeServices->getList();
                    break;
                default:
                    $input = Factory::getInput();
                    $modeServices = WoobookingModel::getInstance('categories');
                    $this->list = $modeServices->getList();
                    break;
            }
            return parent::display($tpl);
        }

        /**
         * @param null $tpl
         * @return false|string
         * @throws Exception
         */
        public function view_config_block_app($tpl = null)
        {
            $input = Factory::getInput();
            $id = $input->getInt('id');
            $modelBlock = WoobookingModel::getInstance('block');
            $this->item = $modelBlock->getItem($id);
            $this->form = $modelBlock->getFormConfigBlock('category', $tpl);
            return parent::display($tpl);
        }

        /**
         * @param $block
         * @param $tpl
         * @return false|string
         * @throws Exception
         */
        public function display_block_app($block, $tpl)
        {
            $tpl = $block->params->get('children_layout', 'list_inside_page');
            $modeServices = WoobookingModel::getInstance('categories');
            $this->list = $modeServices->getList();
            return parent::display_block_app($block, $tpl);
        }
    }
}