<?php

use WooBooking\CMS\Utilities\Utility;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('nb_apps/nb_woobooking/assets/less/view_list_account.less');
?>
    <div class="view-list-account">
        <div class="row">
            <div class="col-md-2">
               <?php $this->loadSharedTemplate('account_menu.account_menu') ?>
           </div>
            <div class="col-md-6">
				<?php foreach ($this->list as $item) { ?>
                    <div class="img-box-avatar">
                        <div>
                            <img src="<?php echo Factory::getRootUrlPlugin() ?>/<?php esc_html_e($item->image) ?>" alt="avatar" />
                        </div>
                    </div>
				<?php } ?>
            </div>
            <div class="col-md-4">
				<?php foreach ($this->list as $item) { ?>
                    <div class="block-content-right">
                        <div class="intro-description">
                            <p><?php esc_attr_e('Welcome','wpbookingpro')?></p>
                            <h1><?php esc_html_e($item->full_name) ?></h1>
                            <p><?php esc_html_e($item->business) ?></p>
                            <p><?php esc_html_e($item->description) ?></p>
                        </div>
                        <div class="info-detail-my-account">
                            <div class="block-item-info">
                                <span><i class="far fa-calendar-alt"></i></span>
                                <span><?php echo WpBookingPro_HtmlFrontend::_('date', $item->birthday, WoobookingText::_('BIRTHDAY')) ?></span>
                            </div>
                            <div class="block-item-info">
                                <span><i class="fas fa-phone-alt"></i></span>
                                <span><?php esc_html_e($item->mobile) ?></span>
                            </div>
                            <div class="block-item-info">
                                <span><i class="far fa-envelope"></i></span>
                                <span><?php esc_html_e($item->email); ?></span>
                            </div>
                            <div class="block-item-info">
                                <span><i class="fas fa-home"></i></span>
                                <span><?php esc_html_e($item->address) ?></span>
                            </div>
                        </div>
                        <div class="social-link-my-account">
                            <a href="facebook.com"><i class="fab fa-facebook-f"></i></a>
                            <a href="instagram.com"><i class="fab fa-instagram"></i></a>
                            <a href="twister.com"><i class="fab fa-twitter"></i></a>
                        </div>
                        <div class="button-edit">
                            <a href="" class="btn btn-primary"><?php esc_attr_e('Edit profile','wpbookingpro')?></a>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-list-account','view_list_account',array(),'nb_apps/nb_woobooking/assets/js/view_list_account.js');