                <?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_ReviewsModel")) {
    /**
     * Class WpBookingPro_ReviewsModel
     */
    class WpBookingPro_ReviewsModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "review";
        /**
         * @var string
         */
        public $context = "reviews";
        /**
         * @var string
         */
        public $modelItem = "review";

        /**
         * @return void|\WooBooking\CMS\Database\DatabaseQuery
         */
        public function buildQuery()
        {
            $orderCol = $this->state->get('list.ordering', 'review.id');
            $query = $this->db->getQuery(true);
            $query->select('review.*')
                ->from($this->getTableName() . ' AS review');

            return $query;
        }
        public function getList()
        {
            $query = $this->db->getQuery(true);
            $query->select("review.*")
                ->from($this->getTableName() . ' AS review')
                ->leftJoin($this->getTableName('service') . ' AS service ON service.id =review.service_id')
                ->select('service.name as service_name');
            return $this->db->setQuery($query)->loadObjectList();
        }

        /**
         * @param string $ordering
         * @param string $direction
         */
        public function populateState($ordering = 'a.id', $direction = 'desc')
        {
            parent::populateState($ordering, $direction); // TODO: Change the autogenerated stub
        }
    }
}