<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Form\Form;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_PackageOrderModel")) {
    /**
     * Class WpBookingPro_OrderModel
     */
    class WpBookingPro_PackageOrderModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $context = "packageOrder";
        /**
         * @var string
         */
        public $table_name = "order";

        /**
         * @return bool|Form
         */
        public function getFormLayoutOrderDetail()
        {
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/Form/Field');
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/WooBooking/form/fields');
            Form::addFormPath(WPBOOKINGPRO_PATH_COMPONENT . '/models/forms');
            try {
                $form = Form::getInstance("order_detail");
            } catch (\Exception $e) {
                wpbookingpro_render_content($e->getMessage());
                die;
                $this->setError($e->getMessage());
                return false;
            }
            return $form;
        }

        /**
         * @param int $id
         * @return mixed|object
         */
        public function getItem($id = 0)
        {
            $item = (object)parent::getItem($id); // TODO: Change the autogenerated stub
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select("order_package.*")
                ->from($this->getTableName('order_package') . ' AS order_package')
                ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=order_package.employee_id')
                ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.image AS employee_image')
                ->leftJoin($this->getTableName('service') . ' AS service ON service.id=order_package.service_id')
                ->select('service.name AS service_name,service.price AS service_price,service.image AS service_image')
                ->leftJoin($this->getTableName('location') . ' AS location ON location.id=order_package.location_id')
                ->select('location.address as location_address')
                ->where('order_package.order_id=' . (int)$item->id);
            $item->list_order_detail = $this->db->setQuery($query)->loadObjectList();
            $customer=[];
            $query->clear()
                ->select('customer.*, CONCAT(customer.first_name," ", customer.last_name) AS customer_full_name')
                ->from($this->getTableName('customer').' AS customer')
                ->where('customer.id='. (int)$item->customer_id)
            ;
            $customer=$this->db->setQuery($query)->loadObjectList();
            $item->customer=reset($customer);
            $list_employee_full_name = [];
            $list_service_name = [];
            $package=[];
            foreach ($item->list_order_detail as &$order_package) {
                $order_package->employee_full_name = Utility::getFullName($order_package->employee_first_name, $order_package->employee_last_name);
                $list_employee_full_name[] = $order_package->employee_full_name;
                $list_service_name[] = $order_package->service_name;
                $query->clear()
                    ->select("order_package_rate.*")
                    ->from($this->getTableName('order_package_rate').' AS order_package_rate')
                    ->where('order_package_rate.order_package_id=' . (int)$order_package->id);
                $list_rate = $this->db->setQuery($query)->loadObjectList();
                foreach ($list_rate as &$rate) {
                    $start_date = Factory::getDate($rate->start_date);
                    $end_date = Factory::getDate($rate->end_date);
                    $since_start = $start_date->diff($end_date);
                    $rate->duration = WoobookingText::_sprintf('TIME_DURATION', $since_start->h, $since_start->i);
                }
                $order_package->rate = reset($list_rate);
                $query->clear()
                    ->select('package.*')
                    ->from($this->getTableName('package').' AS package')
                    ->where('package.id='.(int)$order_package->package_id)
                ;
                $package = $this->db->setQuery($query)->loadObjectList();
            }
            $item->package=reset($package);
            return $item;
        }
    }
}
