<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use Woobooking\CMS\Registry\Registry;
use WooBooking\CMS\Utilities\Utility;
if(!class_exists("WpBookingPro_EmployeesModel")) {
    /**
     * Class WpBookingPro_EmployeesModel
     */
    class WpBookingPro_EmployeesModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "employee";
        /**
         * @var string
         */
        public $context = "employees";

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $query = $this->db->getQuery(true);
            $query->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->where('employee.published=1');;
            $query->order($this->getState('list.ordering', 'employee.ordering') . ' ' . $this->getState('list.direction',
                    'ASC'));
            return $query;
        }

        /**
         * @return mixed
         */
        public function getList()
        {
            $list = parent::getList(); // TODO: Change the autogenerated stub
            foreach ($list as &$item) {
                $item->full_name = Utility::getFullName($item->first_name, $item->last_name);
                $register = new Registry();
                $register->loadString($item->params);
                $item->params = $register;
                $query = $this->db->getQuery(true);
                $query->select('service_employee.employee_id AS employee_id, service_employee.service_id AS service_id')
                    ->from($this->getTableName('service_employee') . ' AS service_employee')
                    ->leftJoin($this->getTableName('service') . ' AS service ON service.id=service_employee.service_id')
                    ->leftJoin($this->getTableName('category') . ' AS category ON category.id=service.category_id')
                    ->select('category.*')
                    ->group('service_employee.employee_id')
                    ->having('service_employee.employee_id=' . (int)$item->id);
                $item->category = $this->db->setQuery($query)->loadObjectList();
            }
            return $list;
        }

        /**
         * @param $list_employee_id
         * @return mixed
         */
        public function getListEmployeeByArrayEmployeeId($list_employee_id)
        {
            $query = $this->db->getQuery(true);
            $query->select("employee.*")
                ->from($this->getTableName('employee') . ' AS employee');
            if (!empty($list_employee_id)) {
                $query->where('employee.id IN(' . implode(',', $list_employee_id) . ')');
            }

            $listEmployee = $this->db->setQuery($query)->loadObjectList();
            foreach ($listEmployee as &$employee) {
                $register = new Registry();
                $register->loadString($employee->params);
                $employee->params = $register;
            }
            return $listEmployee;

        }
    }
}
