<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_ConfigModel")) {
    /**
     * Class WpBookingPro_ConfigModel
     */
    class WpBookingPro_ConfigModel extends WoobookingModel
    {
        /**
         * @var string
         */
        public $context = "config";
        /**
         * @var string
         */
        public $table_name = "config";
        /**
         * @var array
         */
        public static $list_menu_by_xml = array();

        /**
         * @return array|mixed
         */
        public function get_list_view_publish()
        {
            $db = Factory::getDBO();
            $query_check_table = $db->getQuery(true);
            $query_check_table->setQuery("SHOW TABLES LIKE '" . $this->getTableName('view') . "'");
            $tables = $db->setQuery($query_check_table)->loadColumn();
            if (count($tables)) {
                $query = $db->getQuery(true);
                $query->select('view.name')
                    ->from($this->getTableName('view') . ' AS view')
                    ->where('view.published=1');
                $listview = $db->setQuery($query)->loadColumn();
            } else {
                $listview = self::get_list_view_xml();
            }
            return $listview;
        }

        /**
         * @return array
         */
        public static function get_list_view_xml()
        {
            if (empty(self::$list_menu_by_xml)) {
                $file_xml_path_app = WPBOOKINGPRO_PATH_ADMIN_COMPONENT1 . "/views.xml";
                $xml = simplexml_load_file($file_xml_path_app);
                $list_menu_by_xml = [];
                foreach ($xml->view as $view) {
                    $is_system = (string)$view->attributes()['is_system'];
                    if ($is_system == 1) {
                        $list_menu_by_xml[] = (object)[
                            'id' => (string)$view->attributes()['id'],
                            'menu_slug' => (string)$view->attributes()['menu_slug'],
                            'label' => (string)$view->attributes()['label'],
                            'page_title' => (string)$view->attributes()['page_title'],
                            'capability' => (string)$view->attributes()['capability'],
                            'icon' => (string)$view->attributes()['icon'],
                            'is_system' => (string)$view->attributes()['is_system'],
                        ];
                    }
                }
                self::$list_menu_by_xml = $list_menu_by_xml;
            }
            return self::$list_menu_by_xml;
        }
    }
}
