<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Form\Form;
if(!class_exists("WpBookingPro_CheckoutModel")) {
    /**
     * Class WpBookingPro_CheckoutModel
     */
    class WpBookingPro_CheckoutModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "checkout";
        /**
         * @var string
         */
        public $context = "checkout";

        /**
         * @return bool|Form
         */
        public function getFormCheckout()
        {
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/Form/Field');
            Form::addFieldPath(WPBOOKINGPRO_PATH_ROOT . '/lib/WooBooking/form/fields');
            Form::addFormPath(WPBOOKINGPRO_PATH_COMPONENT . '/models/forms');
            try {
                $form = Form::getInstance("form_checkout");
            } catch (\Exception $e) {
                wpbookingpro_render_content($e->getMessage());
                die;
                $this->setError($e->getMessage());
                return false;
            }
            return $form;
        }

        /**
         * @param $data
         * @return array|bool
         * @throws Exception
         */
        public function process_order($data)
        {
            $app = Factory::getApplication();
            $modeCarts = WoobookingModel::getInstance('carts');
            $list_cart = $modeCarts->getList();
            $first_name_customer = $data['first_name'];
            $last_name_customer = $data['last_name'];
            $email_customer = $data['email'];
            $phone_customer = $data['phone'];
            $payment_id = $data['payment_id'];
            $customerModel = WoobookingModel::getInstance('customer');
            $data_customer = [
                "first_name" => $first_name_customer,
                "last_name" => $last_name_customer,
                "mobile" => $phone_customer,
                "email" => $email_customer
            ];
            $customer = $customerModel->save($data_customer);
            $rateModel = WoobookingModel::getInstance('rate');
            $total = 0;
            foreach ($list_cart as $cart) {
                $total += $cart->total;
            }
            $orderModel = WoobookingModel::getInstance('order');
            $data_order = [
                "customer_id" => $customer->id,
                "payment_id" => $payment_id,
                "total" => $total
            ];
            //create order
            $order = $orderModel->save($data_order);
            $orderDetailModel = WoobookingModel::getInstance('orderdetail');
            //create order detail
            $data_order_detail = [
                "id" => 0,
                "order_id" => $order->id,
                "quantity" => 1,
                "total" => $total
            ];
            $oder_detail = $orderDetailModel->save($data_order_detail);
            //create oder detail rate
            $orderDetailRateModel = WoobookingModel::getInstance('orderdetailrate');
            foreach ($list_cart as $cart) {
                $data_order_detail_rate = [
                    "id" => 0,
                    "order_detail_id" => $oder_detail->id,
                    "start_date" => $cart->start_date,
                    "end_date" => $cart->end_date,
                    "employee_id" => $cart->employee_id,
                    "rate_id" => $cart->rate_id,
                    "service_id" => $cart->service_id,
                    "location_id" => $cart->location_id,
                    "total" => $cart->total,
                    "price" => $cart->price,
                    "subtotal" => $cart->subtotal,
                    "quantity" => $cart->quantity,
                ];
                $order_detail_rate = $orderDetailRateModel->save($data_order_detail_rate);
            }
            return $order;
        }
    }
}
