<?php
defined('_WPBOOKINGPRO_EXEC') or die;
use WooBooking\CMS\Form\Form;
use WooBooking\CMS\Registry\Registry;
if(!class_exists("WpBookingPro_BlockModel")) {
    /**
     * Class WpBookingPro_BlockModel
     */
    class WpBookingPro_BlockModel extends WoobookingModelForm
    {
        /**
         * @var string
         */
        public $table_name = "block";
        /**
         * @var string
         */
        public $context = "block";

        /**
         * @param $type
         * @return array|bool|object
         */
        public function createNewBlock($type)
        {
            $array_data = array(
                "type" => $type
            );
            $block = $this->save($array_data);
            return $block;
        }

        /**
         * @param int $id
         * @return mixed|object
         */
        public function getItem($id = 0)
        {
            $item = (object)parent::getItem($id); // TODO: Change the autogenerated stub
            $register_params = new Registry();
            $register_params->loadString(isset($item->params) ? $item->params : null);
            $item->params = $register_params;
            return $item;
        }

        /**
         * @param int $block_id
         * @param bool $loadData
         * @return bool|Form
         */
        public function getFormBlockConfig($block_id = 0, $loadData = true)
        {
            $block = $this->getItem($block_id);
            Form::addFormPath(WPBOOKINGPRO_PATH_ROOT . DS . "blocks/block_$block->type/forms");
            $form = $this->loadFormBlockConfig($block->type . "_config", array('control' => 'jform', 'load_data' => $loadData));
            return $form;
        }

        /**
         * @param null $source
         * @param array $options
         * @param bool $clear
         * @param bool $xpath
         * @return bool|Form
         */
        protected function loadFormBlockPreview($source = null, $options = array(), $clear = false, $xpath = false)
        {
            try {
                $form = Form::getInstance($source, $options, false, $xpath);
                if (isset($options['load_data']) && $options['load_data']) {
                    // Get the data for the form.
                    $data = $this->loadFormData();
                } else {
                    $data = array();
                }


                // Load the data into the form after the plugins have operated.
                $form->bind($data);
            } catch (\Exception $e) {
                wpbookingpro_render_content($e->getMessage());
                die;
                $this->setError($e->getMessage());

                return false;
            }


            return $form;
        }

        /**
         * @param null $source
         * @param array $options
         * @param bool $clear
         * @param bool $xpath
         * @return bool|Form
         */
        protected function loadFormBlockConfig($source = null, $options = array(), $clear = false, $xpath = false)
        {
            try {
                $form = Form::getInstance($source, $options, false, $xpath);
                if (isset($options['load_data']) && $options['load_data']) {

                    // Get the data for the form.
                    $data = $this->loadFormData();
                } else {
                    $data = array();
                }


                // Load the data into the form after the plugins have operated.
                $form->bind($data);
            } catch (\Exception $e) {
                wpbookingpro_render_content($e->getMessage());
                die;
                $this->setError($e->getMessage());

                return false;
            }


            return $form;
        }

        /**
         * @param int $block_id
         * @return bool|Form
         */
        public function getFormBlockPreview($block_id = 0)
        {
            $block = $this->getItem($block_id);

            Form::addFormPath(WPBOOKINGPRO_PATH_ROOT . DS . "blocks/block_$block->type/forms");
            $form = $this->loadFormBlockPreview($block->type . "_preview", array('control' => 'form'));
            return $form;
        }

        /**
         * @param string $open_source_client_id
         * @return bool|mixed
         */
        public function getBlockByOpenSourceId($open_source_client_id = "")
        {

            $query = $this->_db->getQuery(true);
            $query->select('*')
                ->from($this->getTableName())
                ->where('open_source_client_id=' . $query->quote($open_source_client_id));
            $item = $this->_db->setQuery($query)->loadObject();
            if (!$item) {
                return false;
            }
            $register_params = new Registry();
            $register_params->loadString(isset($item->params) ? $item->params : null);
            $item->params = $register_params;
            return $item;
        }

        /**
         * @param array $data
         * @return array|bool|object
         */
        public function save($data = array())
        {
            $item = parent::save($data); // TODO: Change the autogenerated stub
            if ($item) {
                $register_params = new Registry();
                $register_params->loadString($item->params);
                $item->params = $register_params;
                return $item;
            }
            return false;
        }

        /**
         * @param string $block_name
         * @param array $data
         * @param bool $loadData
         * @return bool|Form
         */
        public function getFormConfigBlockModule($block_name = "", $data = array(), $loadData = true)
        {
            Form::addFormPath(WPBOOKINGPRO_PATH_ROOT . "/blocks/block_$block_name");
            // Get the form.
            $form = $this->loadForm($block_name . "_config", array('control' => 'jform', 'load_data' => $loadData));
            if (empty($form)) {
                return false;
            }
            return $form;
        }

        /**
         * @param string $block_name
         * @param array $data
         * @param bool $loadData
         * @return bool|Form
         */
        public function getFormViewBlockModule($block_name = "", $data = array(), $loadData = true)
        {
            Form::addFormPath(WPBOOKINGPRO_PATH_ROOT . "/blocks/block_$block_name");
            // Get the form.
            $form = $this->loadForm($block_name . "_config", array('control' => 'jform', 'load_data' => $loadData));
            if (empty($form)) {
                return false;
            }
            return $form;
        }

        /**
         * @param string $view
         * @param $tpl
         * @param array $data
         * @param bool $loadData
         * @return bool|Form
         */
        public function getFormConfigBlock($view = "", $tpl, $data = array(), $loadData = true)
        {
            Form::addFormPath(WPBOOKINGPRO_PATH_COMPONENT . "/views/$view/tmpl");
            // Get the form.
            $form = $this->loadForm($tpl, array('control' => 'jform', 'load_data' => $loadData));
            if (empty($form)) {
                return false;
            }
            return $form;
        }
    }
}
