<?php

defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\CMS\Utilities\Utility;

extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$modelEmployees = WoobookingModel::getInstance('employees');
$list = $modelEmployees->getList();
$list_time = [];
$list_employee_id = [];
if (!is_array($value)) {
	$list_employee_id[] = $value;
} else {
	$list_employee_id = $value;
}
?>
    <div class="<?php esc_html_e($class); ?> field-employees field-employee-<?php esc_html_e($name_format); ?>">
        <select name="<?php esc_html_e($name); ?>" <?php echo($multiple ? ' multiple ' : "") ?>class="list-employee">
            <option value=""><?php esc_attr_e('Select employee','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo(in_array($item->id, $list_employee_id) ? ' selected ' : '') ?> value="<?php esc_html_e($item->id); ?>"><?php esc_html_e($item->full_name); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_HtmlFrontend::_('jquery.select2');
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/employees.less');
$doc->addScriptApplySelector('.field-employees','field_employees',array(
    "field_name"=>  $name,
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/employees.jquery.js');