<?php

defined('_WPBOOKINGPRO_EXEC') or die;

use WooBooking\CMS\Utilities\Utility;

extract($displayData);


WpBookingPro_HtmlFrontend::_('jquery.framework');
WpBookingPro_HtmlFrontend::_('jquery.select2');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list_employee = $value;
?>
    <div id="<?php esc_html_e($id_by_name) ?>"
         class="<?php esc_html_e($class); ?> field-employeeimage-<?php esc_html_e($name_format) ?> field-employeeimage">
        <div class="row">
            <ul class="list-employee">
                <?php foreach ($list_employee as $item) { ?>
                        <div class="col-sm-4">
                            <li>
                                <div class="wrapper-employee" data-employee_id="<?php esc_html_e($item->id); ?>">
                                    <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                                    <div class="img-box">
                                        <div>
                                            <img class="employee-image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($item->image); ?>" alt="employee-image" />
                                        </div>
                                    </div>
                                    <p><?php esc_html_e($item->full_name); ?></p>
                                    <input type="hidden" name="<?php esc_html_e($name); ?>" />
                                </div>
                            </li>
                        </div>
                <?php } ?>
            </ul>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_HtmlFrontend::_('jquery.select2');
$doc->addLessStylesheet('nb_apps/nb_woobooking/layouts/WooBooking/form/field/employeeimage.less');
$doc->addScriptApplySelector('.field-employeeimage','field_employeeimage',array(
    "field_name"=>  $name
),'nb_apps/nb_woobooking/layouts/WooBooking/form/field/employeeimage.jquery.js');