<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_RatesController")) {
    /**
     * Class WpBookingPro_RatesController
     */
    class WpBookingPro_RatesController extends woobooking_controller_frontend
    {
        /**
         * @return mixed
         * @throws Exception
         */
        function get_rate_available_date()
        {
            $input = Factory::getInput();
            $data = $input->getData()['data'];
            $modelRates = WoobookingModel::getInstance('rates');
            return $modelRates->get_rate_available_date_booking_training($data);
        }

        /**
         * @return mixed
         * @throws Exception
         */
        function ajax_search_rate()
        {
            $input = Factory::getInput();
            $data = $input->getData();
            $app = Factory::getApplication();
            $modelRates = WoobookingModel::getInstance('rates');
            return $modelRates->get_rate_available_date($data);
        }

        /**
         * @return mixed
         * @throws Exception
         */
        function get_rates_of_date()
        {
            $input = Factory::getInput();
            $post = json_decode(file_get_contents('php://input'));
            $data = (array)$post->data;
            $modelRates = WoobookingModel::getInstance('rates');
            return $modelRates->get_rate_available_date_booking_training($data);
        }

        /**
         * @return mixed
         * @throws Exception
         */
        public function get_list_rate_by_event()
        {
            $input = Factory::getInput();
            $data = $input->getData();
            $event_id = (int)$data["event_id"];
            $modelRates = WoobookingModel::getInstance('rates');
            return $modelRates->get_rate_available_by_event_id($event_id);
        }
    }
}
?>