"use strict";
(function ($) {
    $.view_service_detail_new = function (element, options) {
        let defaults = {
            list_event: [],
            person: 1,
            service_item: [],
            title: ''
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let title = plugin.settings.title;
            if (title.trim() === '') {
                $('body').find('.entry-title').html('Service detail')
            } else {
                $('body').find('.entry-title').html(title)
            }

            let list_event = plugin.settings.list_event;
            let service_item = plugin.settings.service_item;
            let event_id;
            let event_choosen;
            let $gallery_large = $element.find('.block-gallery-slider-large');
            let $gallery_small = $element.find('.block-gallery-slider-small');
            $gallery_large.slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                prevArrow: ".arrow-prev",
                nextArrow: ".arrow-next",
                fade: true,
                asNavFor: '.block-gallery-slider-small',
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            arrows: false,
                            slidesToShow: 1,
                            slidesToScroll: 1
                        }
                    }
                ]

            });
            $gallery_small.slick({
                slidesToShow: 4,
                slidesToScroll: 1,
                asNavFor: '.block-gallery-slider-large',
                arrows: false,
                focusOnSelect: true,
                responsive: [
                    {
                        breakpoint: 576,
                        settings: {
                            arrows: false,
                            dots: true,
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    }
                ]
            });
            let person = plugin.settings.person;
            $element.find('.counter-minus').click(function (e) {
                person = $element.find('input[type="text"].increment-number').val();
                $element.find('.number-person').text(person);
                if (typeof event_choosen !== 'undefined') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                } else {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                }

            });
            $element.find('.counter-plus').click(function (e) {
                person = $element.find('input[type="text"].increment-number').val();
                $element.find('.number-person').text(person);
                if (typeof event_choosen !== 'undefined') {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price * person));
                } else {
                    $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                    $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(service_item.price * person));
                }
            });
            $element.find('form[name="client-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            let $employee_input = $element.find('input[name=employee_id]');
            $employee_input.on('change', function () {
                let employee_id = $(this).val();
                let list_employee = service_item.list_employee;
                let employee_choosen = list_employee.find(function (employee) {
                    if (employee.id == employee_id) {
                        return employee;
                    }
                });
                $element.find('.trainer-info').text(`${employee_choosen.first_name} ${employee_choosen.last_name}`)
            });

            let list_working_day = service_item.working_day;
            let array_day_by_number = [];
            if (typeof list_working_day !== 'undefined' && list_working_day !== null && list_working_day.trim() !== '') {
                list_working_day = JSON.parse(list_working_day);
                let week = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
                let array_diff = plugin.arr_diff(list_working_day, week);
                let day_of_week = {
                    'Sunday': 0,
                    'Monday': 1,
                    'Tuesday': 2,
                    'Wednesday': 3,
                    'Thursday': 4,
                    'Friday': 5,
                    'Saturday': 6
                };
                for (const prop in day_of_week) {
                    for (let i = 0; i < array_diff.length; i++) {
                        if (prop === array_diff[i]) {
                            array_day_by_number.push(day_of_week[prop]);
                        }
                    }
                }
            }

            $element.find('.form_datetime').datetimepicker('setDaysOfWeekDisabled', array_day_by_number);
            $element.find('.time-booking').on('change', function () {
                let value = $(this).val();
                let time_start = moment(value).format('LT');
                let time_end = moment(value).add(service_item.duration, 'hour').format('LT');
                let date_book = moment(value).format('YYYY-MM-DD');
                if (value !== '') {
                    $element.find('.local-time').text(`${time_start} - ${time_end}`);
                    $element.find('.date-info').text(date_book);
                } else {
                    $element.find('.local-time').text('');
                    $element.find('.date-info').text('');
                }
            });
            $element.find('.btn-book-now').click(function (e) {
                let $form = $(this).closest('form[name="client-form"]');
                $form.find('input[name="task"]').val('booking.book_service');
                let employee_id = $form.find('input[name="employee_id"]').val();
                if (employee_id === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    }, 500, "linear");
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Expert</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                let time_value = $form.find('.mirror_field').val();
                if (time_value === "") {
                    $('body,html').animate({
                        scrollTop: $element.find('.block-booking-information').offset().top
                    }, 500, "linear");
                    $.alert({
                        title: '',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select your Time</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container: '.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                if (!$form.valid()) {
                    $('body,html').animate({
                        scrollTop: $element.find('.wrapper-block-check-out').offset().top
                    }, 500, "linear");
                    return false;
                }
                $form.submit();
            });
            $element.find('.btn-booknow').click(function () {
                let $block_event = $(this).closest('.block-event-item');
                $('body,html').animate({
                    scrollTop: $element.find('form.booking-form').offset().top
                }, 500, "linear");
                event_id = $block_event.data('event_id');
                event_choosen = list_event.find(function (event) {
                    if (event.id == event_id) {
                        return event;
                    }
                });
                $element.find('input[name="event_id"]').val(event_id);
                $element.find('.location-info').text(event_choosen.list_location[0].address)
                $element.find('.base-price').html('<span>$</span>' + plugin.formatNumber(event_choosen.price));
                $element.find('.total-cost-sum').html('<span>$</span>' + plugin.formatNumber(event_choosen.price));
            });


            $element.find('form[name="reviewer-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-add-review').click(function (e) {
                let $form = $(this).closest('form[name="reviewer-form"]');
                $form.find('input[name="task"]').val('review.add_review');
                let rating_service = $form.find('input[name="rating_service"]').val();
                $form.submit();
            });
        };

        plugin.formatNumber = function (num) {
            return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,')
        };
        plugin.arr_diff = function (a1, a2) {
            let a = [], diff = [];
            if (a1.length > 0 && a2.length > 0) {
                for (let i = 0; i < a1.length; i++) {
                    a[a1[i]] = true;
                }
                for (let i = 0; i < a2.length; i++) {
                    if (a[a2[i]]) {
                        delete a[a2[i]];
                    } else {
                        a[a2[i]] = true;
                    }
                }
                for (let k in a) {
                    diff.push(k);
                }
            }
            return diff;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_service_detail_new = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_service_detail_new')) {
                let plugin = new $.view_service_detail_new(this, options);
                $(this).data('view_service_detail_new', plugin);
            }
        });
    }
})(jQuery);
