"use strict";
(function ($) {
    $.view_list_layout_service2 = function (element, options) {
        let defaults = {
            service_item: '',
            visiblePages: 5,
            services: [],
            rates: [],
            current_page: 1,
            items_per_page: 3,
            base_price: 0,
            base_price_format: 0,
            total_record: 100,
            limit: 6,
            start: 0,
            title: ''
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let title=plugin.settings.title;
            if (title.trim() !== ''){
                $('body').find('.entry-title').html(title)
            }else{
                $('body').find('.entry-title').html('List Services');
                $('body').find('.nb-breadcrumb .fbc-page li.active span').html('List Services');
            }
            $element.find('p.lowest.active').text('Highest price');
            let $form=$element.find('form.list-service');
            $element.find('.style-display a').on('click',function (e) {
                let display=$(this).data('display');

                $element.find('input[name="style"]').val(display);
                $form.submit();
            });
            $element.find('.sort-display a').on('click',function (e) {
                let key_sort=$(this).data('key_sort');
                let direction=$(this).data('direction');
                let text =$(this).text();
                $element.find('p.lowest').text(text);
                $element.find('input[name="key_sort"]').val(key_sort);
                $element.find('input[name="direction"]').val(direction);
                $form.submit();
            });
            let $checkbox_category = $element.find('.check-box-category');
            let $checkbox_service = $element.find('.check-box-service');
            $checkbox_category.on('ifChecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                $ul_list_service.find('.check-box-service').iCheck('check');

            });


            $checkbox_category.on('ifUnchecked', function (event) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service = $block_label.next();
                if (!triggeredByChild) {
                    $ul_list_service.find('.check-box-service').iCheck('uncheck');
                }
            });
            $checkbox_service.on('ifUnchecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                $block_label.find('.check-box-category').iCheck('uncheck');
            });
            $checkbox_service.on('ifChecked', function (event) {
                let $ul_list_service = $(this).closest('.ul-list-service');
                let $block_label = $ul_list_service.prev();
                let $current_service=$ul_list_service.find('.check-box-service');
                if ($current_service.filter(':checked').length === $current_service.length) {
                    $block_label.find('.check-box-category').iCheck('check');
                }
            });

            $element.find('.ul-list-service').slideUp();
            $element.find('.icon-nb-down-arrow').click(function (e) {
                let $block_label = $(this).closest('.block-label');
                let $ul_list_service =$block_label.next();
                $ul_list_service.slideToggle();
                $(this).toggleClass('active')
            });

            $element.find('select.list-location').select2();
            $element.find('select.list-employee').select2();
            $element.find('select.sorting-training').select2();
            $element.find('.heart').on('click', function (e) {
                let $heart=$(this).find('.fa-heart')
                $heart.toggleClass('far fas');
                e.preventDefault();
            });
            let total_record=plugin.settings.total_record;
            let limit=plugin.settings.limit;
            let start=plugin.settings.start;
            let $fist_show=true;
            if (total_record>=limit){
                $element.find('#pagination-services').twbsPagination({
                    totalPages: parseInt((total_record/limit) + 1),
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.list-service');
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            } else {
                $element.find('#pagination-services').twbsPagination({
                    totalPages: 1,
                    visiblePages: 3,
                    startPage:(start/limit)+1,
                    onPageClick: function (event, page) {
                        if($fist_show===false) {
                            let $form = $element.find('form.list-service');
                            $element.find('input[name="start"]').val(page*limit-limit);
                            $form.submit();
                            console.log("Page", page);
                            $('#page-content').text('Page ' + page);
                        }
                        $fist_show=false;
                    }
                });
            }




        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.example_function = function () {
        };
        plugin.init();
    };
    $.fn.view_list_layout_service2 = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_list_layout_service2')) {
                let plugin = new $.view_list_layout_service2(this, options);
                $(this).data('view_list_layout_service2', plugin);
            }
        });
    }
})(jQuery);
