<?php
use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;

extract($displayData);

WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');

$list = '';

if ($options)
{
    $list = 'list="' . $id . '_datalist"';
}

$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;

$attributes = array(
    !empty($class) ? 'class="' . $class . '"' : '',
    !empty($size) ? 'size="' . $size . '"' : '',
    $disabled ? 'disabled' : '',
    $readonly ? 'readonly' : '',
    $list,
    strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
    $onchange ? ' onchange="' . $onchange . '"' : '',
    !empty($maxLength) ? $maxLength : '',
    $required ? 'required aria-required="true"' : '',
    $autocomplete,
    $autofocus ? ' autofocus' : '',
    $spellcheck ? '' : 'spellcheck="false"',
    !empty($inputmode) ? $inputmode : '',
    !empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);

$id_by_name="element_field_".str_replace(array('[',']'),'_',$name);
$data=$displayData['field']->getForm()->getData();
$modelEmployees=WoobookingModel::getInstance('employees');

$list=$modelEmployees->getList();
$list_time=[];
$list_employee_id=[];
if(!is_array($value)){
    $list_employee_id[]=$value;
}else{
    $list_employee_id=$value;
}
?>
    <div id="<?php wpbookingpro_render_content($id_by_name) ?>" class="<?php wpbookingpro_render_content($class); ?> field-employees">
        <select name="<?php wpbookingpro_render_content($name); ?>" <?php $multiple?' multiple ':null ?> class="list-employee">
            <option value=""><?php echo WoobookingText::_('SELECT_EMPLOYEE') ?></option>
            <?php foreach ($list as $item){ ?>
                <option <?php echo  in_array($item->id,$list_employee_id)?' selected ':null ?> value="<?php wpbookingpro_render_content($item->id);?>"><?php wpbookingpro_render_content($item->full_name);?></option>
            <?php } ?>
        </select>
    </div>
<?php

$doc=Factory::getDocument();
$doc->addScriptApplySelector('.field-employees','field_employees',array(
),'layouts/WooBooking/form/field/employees.jquery.js');