<?php
    $item = $this->item;
    $max_star = 5;
    $tour_rating=($item->rating_service + $item->rating_staff  + $item->rating_ambience)/3;
    while ($tour_rating > $max_star) {
        $tour_rating = $tour_rating - $max_star;
    }

    $star = $tour_rating % 10;
    $non_star = ($max_star - $tour_rating) % 10;
    $half_star = ceil($max_star-$star-$non_star);
    $i = 1;
?>
<tr data-id="<?php esc_html_e($item->id); ?>">
    <td class="nowrap"><i class="fas fa-align-center"></i></td>
    <td class="nowrap"><input type="checkbox" class="checkbox-item-review" name="list_delete_review_id[]"  value="<?php esc_html_e($item->id); ?>" /></td>
    <td class="name nowrap"><?php esc_html_e($item->name); ?></td>
    <td class="note nowrap"><?php esc_attr_e($item->comment)?></td>
    <td class="note nowrap"><?php esc_attr_e($item->email)?></td>
    <td class="rating nowrap">
        <?php if($item->rating_service >= 0 && $item->rating_staff >= 0 && $item->rating_ambience >= 0) {?>
            <?php for ($i=0; $i <$star; $i++) {?>
                <li class="item-star"><i class="fas fa-star"></i></li>
            <?php }?>
            <?php for ($i=0; $i <$half_star; $i++) {?>
                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
            <?php }?>
            <?php for ($i=0; $i <$non_star; $i++) {?>
                <li class="item-star"><i class="far fa-star"></i></li>
            <?php }?>
        <?php }?>
    </td>
    <td class="name nowrap"><?php esc_html_e($item->service_name); ?></td>
    <td class="note nowrap"><?php esc_attr_e($item->description)?></td>
    <td class="id nowrap"><?php esc_html_e($item->id); ?></td>
    <td class="nowrap"><a href="javascript:void(0)" data-id="<?php esc_html_e($item->id); ?>"
           class="btn btn-primary btn-edit-review"><i class="far fa-edit"></i> <?php esc_attr_e('Edit','wpbookingpro')?></a></td>
</tr>
