<?php
$item = $this->item;
?>
<div class="wrapper-employee-item" data-employee_id="<?php esc_html_e($item->id); ?>">
    <input type="checkbox" class="delete-employee"   name="list_delete_employee_id[]" value="<?php esc_html_e($item->id); ?>" style="display: none"/>
    <span class="checkmark"></span>
    <div class="wrapper-employee-content">
        <div class="employee-item-image pull-left">
            <div>
                <img class="image-cover" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?><?php echo ($item->cover == null) ? 'upload/employees/images/cover/user1.jpeg' : $item->cover ?>" alt="employee-item-image" />
            </div>
        </div>
        <div class="employee-item-content pull-left">
            <p><label class="name"><?php esc_html_e(ucwords($item->full_name)) ?></label></p>
            <p><label class="email"><?php esc_html_e($item->email); ?></label></p>
            <p><label class="mobile"><?php esc_html_e($item->mobile); ?></label></p>
        </div>
    </div>
    <div class="employee-action">
		<?php if ($item->published == 1) { ?>
            <div class="away">
                <p><?php esc_attr_e('Away','wpbookingpro') ?></p>
            </div>
		<?php } else { ?>
            <div class="away">
                <p><?php esc_attr_e('Offline','wpbookingpro') ?></p>
            </div>
		<?php } ?>
        <button class="btn btn-primary btn-edit-employee" type="button" data-id="<?php esc_html_e($item->id); ?>"><i
                    class="fas fa-edit"></i><span><?php esc_attr_e('Edit','wpbookingpro') ?></span></button>
    </div>
</div>
