<?php
defined('_WPBOOKINGPRO_EXEC') or die;
if(!class_exists("WpBookingPro_StatesModel")) {
    /**
     * Class WpBookingPro_StatesModel
     */
    class WpBookingPro_StatesModel extends WoobookingModelList
    {
        /**
         * @var string
         */
        public $table_name = "state";
        /**
         * @var string
         */
        public $context = "states";
        /**
         * @var string
         */
        public $modelItem = "state";

        /**
         * @return \WooBooking\CMS\Database\DatabaseQuery
         */
        public function getListQuery()
        {
            $orderCol = $this->state->get('list.ordering', 'category.id');
            $query = $this->db->getQuery(true);
            $query->select('state.*')
                ->from($this->getTableName() . ' AS state')
                ->leftJoin($this->getTableName('country') . ' AS country ON country.id =state.country_id')
                ->select('country.countryname');
            return $query;
        }

        /**
         * @param string $ordering
         * @param string $direction
         */
        public function populateState($ordering = 'a.id', $direction = 'desc')
        {
            parent::populateState($ordering, $direction); // TODO: Change the autogenerated stub
        }

        /**
         * @return mixed
         */
        public function getListAll()
        {
            $query = $this->db->getQuery(true);
            $query->select("a.*")
                ->from($this->getTableName() . ' AS a')
                ->leftJoin($this->getTableName('country') . ' AS country ON country.id =a.country_id')
                ->select('country.countryname');
            return $this->db->setQuery($query)->loadObjectList();
        }
    }
}