<?php

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

if ($meter) {
	WpBookingPro_Html::_('script', 'system/passwordstrength.js',
		array('version' => 'auto', 'relative' => true, 'framework' => true));
	
	Factory::getDocument()->addScriptDeclaration(
		"
		jQuery(document).ready(function() {
			new Form.PasswordStrength('" . $id . "',
				{
					threshold: " . $threshold . ",
					onUpdate: function(element, strength, threshold) {
						element.set('data-passwordstrength', strength);
					}
				});
		});"
	);
}

WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$attributes = array(
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	!$autocomplete ? 'autocomplete="off"' : '',
	!empty($class) ? 'class="' . $class . '"' : '',
	$readonly ? 'readonly' : '',
	$disabled ? 'disabled' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	!empty($maxLength) ? 'maxlength="' . $maxLength . '"' : '',
	$required ? 'required aria-required="true"' : '',
	$autofocus ? 'autofocus' : '',
);
?>
<input type="password" id="<?php
esc_html_e($id); ?>" name="<?php
esc_html_e($name); ?>"  value="<?php
esc_html_e(htmlspecialchars($value, ENT_COMPAT, 'UTF-8')); ?>" <?php
echo(implode(' ', $attributes)); ?> />
