<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('script', 'system/html5fallback.js',
	array('version' => 'auto', 'relative' => true, 'conditional' => 'lt IE 9'));
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$args = array();
$products = wc_get_products($args);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-opensourcelinkid">
        <div class="wrapper-field-opensourcelinkid">
            <select name="<?php esc_html_e($name); ?>" required="<?php echo esc_html_e($required) ?>"
                    class="open-source-link">
                <option value=""><?php esc_attr_e('Select product','wpbookingpro') ?></option>
				<?php foreach ($products as $product) { ?>
                    <option <?php echo($product->get_id() == $value ? ' selected ' : '') ?>
                            value="<?php esc_html_e($product->get_id()); ?>"><?php esc_html_e($product->get_name()); ?></option>
				<?php } ?>
            </select>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-opensourcelinkid','field_opensourcelinkid',array(
        "step"=>  (int)$step,
        "tool_check"=>  json_encode(array_reverse($toolChecked)),
    )
    ,'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/opensourcelinkid.jquery.js');