<?php

use WooBooking\CMS\Utilities\Utility;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
    $list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
    !empty($class) ? 'class="' . $class . '"' : '',
    !empty($size) ? 'size="' . $size . '"' : '',
    $disabled ? 'disabled' : '',
    $readonly ? 'readonly' : '',
    $list,
    strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
    $onchange ? ' onchange="' . $onchange . '"' : '',
    !empty($maxLength) ? $maxLength : '',
    $required ? 'required aria-required="true"' : '',
    $autocomplete,
    $autofocus ? ' autofocus' : '',
    $spellcheck ? '' : 'spellcheck="false"',
    !empty($inputmode) ? $inputmode : '',
    !empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-gender">
        <select class="list-gender" name="<?php esc_html_e($name); ?>">
            <option value=""><?php esc_attr_e('Select Gender','wpbookingpro') ?></option>
            <option <?php echo($value == 'a.ordering ASC' ? ' selected ' : '') ?> value="a.ordering ASC"><?php esc_attr_e('Male','wpbookingpro') ?></option>
            <option <?php echo($value == 'a.ordering DESC' ? ' selected ' : '') ?> value="a.ordering DESC"><?php esc_attr_e('Female','wpbookingpro') ?></option>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingPro_Html::_('jquery.select2');
$doc->addScriptApplySelector('.field-gender', 'field_gender', array(), 'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/gender.jquery.js');
