<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-finance">
        <div class="row">
            <div class="col-md-12">
                <div class="custom-info">
                    <p><?php esc_attr_e_('Customer','wpbookingpro') ?></p>
                    <p>
                        <span><?php esc_attr_e_('Valdecy Oliveira','wpbookingpro') ?></span>
                        <span><?php esc_attr_e_('brancodesign2014@gmail.com','wpbookingpro') ?></span>
                    </p>
                </div>
            </div>
            <div class="col-md-12">
                <p><?php esc_attr_e_('Payment','wpbookingpro') ?></p>
                <div class="info-payment">
                    <div class="info-payment-item">
                        <span><?php esc_attr_e_('Date','wpbookingpro') ?></span>
                        <span><?php esc_attr_e_('December 7, 2019','wpbookingpro') ?></span>
                    </div>
                    <div class="info-payment-item">
                        <span><?php esc_attr_e_('Payment Method','wpbookingpro') ?></span>
                        <span><i class="fas fa-hand-holding-heart"></i><?php esc_attr_e_('On-site','wpbookingpro') ?></span>
                    </div>
                    <div class="info-payment-item">
                        <span><?php esc_attr_e_('Status','wpbookingpro') ?></span>
                        <span><i class="fas fa-sync"></i><?php esc_attr_e_('Pending','wpbookingpro') ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <p><?php esc_attr_e_('Appointment Info','wpbookingpro') ?></p>
                <div class="info-appointment">
                    <div class="info-appointment-item">
                        <span><?php esc_attr_e_('Appointment','wpbookingpro') ?></span>
                        <span><?php esc_attr_e_('Pregnant Yoga','wpbookingpro') ?></span>
                    </div>
                    <div class="info-appointment-item">
                        <span><?php esc_attr_e_('Date','wpbookingpro') ?></span>
                        <span><?php esc_attr_e_('December 7, 2019 10:30 am','wpbookingpro') ?></span>
                    </div>
                    <div class="info-appointment-item">
                        <span><?php esc_attr_e_('Employee','wpbookingpro') ?></span>
                        <span><?php esc_attr_e_('Andrea Barber','wpbookingpro') ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="payment-sum">
                    <div class="payment-sum-item">
                        <span><?php esc_attr_e_('Service Price','wpbookingpro') ?></span>
                        <span>$80.00</span>
                    </div>
                    <div class="payment-sum-item">
                        <span><?php esc_attr_e_('Service Price','wpbookingpro') ?></span>
                        <span>$0.00</span>
                    </div>
                    <div class="payment-sum-item">
                        <span><?php esc_attr_e_('Subtotal','wpbookingpro') ?></span>
                        <span>$80.00</span>
                    </div>
                    <div class="payment-sum-item">
                        <span><?php esc_attr_e_('Discount','wpbookingpro') ?></span>
                        <span>$0.00</span>
                    </div>
                    <div class="payment-sum-item">
                        <span><?php esc_attr_e_('Paid','wpbookingpro') ?></span>
                        <span>$0.00</span>
                    </div>
                    <div class="payment-sum-item">
                        <span><?php esc_attr_e_('Due','wpbookingpro') ?></span>
                        <span>$80.00</span>
                    </div>
                    <div class="payment-sum-item total">
                        <span><?php esc_attr_e_('Total','wpbookingpro') ?></span>
                        <span>$80.00</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/finance.less');
$doc->addScriptApplySelector('.field-finance','field_finance',array(
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/finance.jquery.js');
