<?php
use WooBooking\CMS\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingPro_Html::_('jquery.framework');
WpBookingPro_Html::_('jquery.select2');
WpBookingPro_Html::_('jquery.auto_numeric');
WpBookingPro_Html::_('jquery.scroll_to');
WpBookingPro_Html::_('jquery.base64');
$list = '';
if ($options) {
	$list = 'list="' . $id . '_datalist"';
}
$autocomplete = !$autocomplete ? ' autocomplete="off"' : ' autocomplete="' . $autocomplete . '"';
$autocomplete = $autocomplete === ' autocomplete="on"' ? '' : $autocomplete;
$attributes = array(
	!empty($class) ? 'class="' . $class . '"' : '',
	!empty($size) ? 'size="' . $size . '"' : '',
	$disabled ? 'disabled' : '',
	$readonly ? 'readonly' : '',
	$list,
	strlen($hint) ? 'placeholder="' . htmlspecialchars($hint, ENT_COMPAT, 'UTF-8') . '"' : '',
	$onchange ? ' onchange="' . $onchange . '"' : '',
	!empty($maxLength) ? $maxLength : '',
	$required ? 'required aria-required="true"' : '',
	$autocomplete,
	$autofocus ? ' autofocus' : '',
	$spellcheck ? '' : 'spellcheck="false"',
	!empty($inputmode) ? $inputmode : '',
	!empty($pattern) ? 'pattern="' . $pattern . '"' : '',
);
WpBookingPro_Html::_('jquery.increment');
if (!method_exists('render_field_extra')) {
	function render_field_extra($data = array())
	{
		ob_start();
		?>
        <div class="row wrapper-extra-item" data-id="<?php esc_html_e($data['item']->id) ?>">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12">
                        <div class="pull-left">
                            <button type="button" class="btn btn-link"><i class="fas fa-bars"></i></button>
                            <span class="extra-name"><?php esc_html_e($data['item']->name) ?></span>
                        </div>
                        <div class="pull-right">
                            <button type="button" class="btn btn-link btn-extra-edit"><i class="far fa-edit"></i>
                            </button>
                            <button type="button" class="btn btn-link btn-extra-remove"><i class="far fa-trash-alt"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row summary">
                    <div class="col-md-12">
                        <table class="table">
                            <thead>
                            <th><?php esc_attr_e('Duration','wpbookingpro') ?></th>
                            <th><?php esc_attr_e('Price','wpbookingpro') ?></th>
                            <th><?php esc_attr_e('Maximum Quantity','wpbookingpro') ?>:</th>
                            </thead>
                            <tbody>
                            <tr class="table-success">
                                <td><span class="duration"><?php esc_html_e($data['item']->duration) ?></span>h</td>
                                <td><span class="price"><?php esc_html_e($data['item']->price) ?></span>$</td>
                                <td><span class="quality"><?php esc_html_e($data['item']->quality) ?></span></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?php esc_attr_e('Name','wpbookingpro') ?></label>
                                <input type="text" class="form-control extra-name" value="<?php esc_html_e($data['item']->name) ?>" placeholder="<?php esc_attr_e('Name','wpbookingpro') ?>" />
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php esc_attr_e('Duration','wpbookingpro') ?></label>
                                <select class="extra-time-buffer form-control">
                                    <option value=""><?php esc_attr_e('Please select duration','wpbookingpro') ?></option>
									<?php for ($i = 0; $i <= 23; $i++) { ?>
										<?php if ($i !== 0) { ?>
                                            <option <?php echo($data['item']->duration == $i ? ' selected ' : '') ?>
                                                    value="<?php esc_html_e($i) ?>"><?php printf("%sh", $i) ?></option>
                                            <option <?php echo($data['item']->duration == ($i + 0.5) ? ' selected ' : '') ?>
                                                    value="<?php echo($i + 0.5) ?>"><?php printf("%sh 30min", $i) ?></option>
										<?php } else { ?>
                                            <option <?php echo($data['item']->duration == $i ? ' selected ' : '') ?>
                                                    value="<?php esc_html_e($i) ?>"><?php esc_attr_e('30min','wpbookingpro') ?></option>
										<?php } ?>
									<?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php esc_attr_e('Price','wpbookingpro') ?></label>
                                <input type="text" data-a-sign="$" value="<?php esc_html_e($data['item']->price) ?>" class="form-control extra-price" placeholder="<?php esc_attr_e('Price','wpbookingpro') ?>" />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label><?php esc_attr_e('Maximum Quantity','wpbookingpro') ?></label>
                                <div class="handle-counter">
                                    <button type="button" class="counter-minus btn btn-primary">-</button>
                                    <input type="text" class="increment-number form-control" value="<?php esc_html_e($data['item']->quality) ?>" />
                                    <button type="button" class="counter-plus btn btn-primary">+</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label><?php esc_attr_e('Description','wpbookingpro') ?></label>
                                <textarea class="form-control extra-description"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="pull-right">
                                <button type="button" class="btn btn-primary btn-extra-cancel"><?php esc_attr_e('Cancel','wpbookingpro') ?></button>
                                <button type="button" class="btn btn-primary btn-extra-save"><?php esc_attr_e('Save','wpbookingpro') ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="<?php esc_html_e($data['name']) ?>[]" value="<?php echo base64_encode(json_encode($data['item'])) ?>" />
            </div>
        </div>
		<?php
		return ob_get_clean();
	}
}
$data = [];
$data['name'] = $name;
$content_extra = render_field_extra($data);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-extra">
        <div class="list-extra">
            <?php foreach ($value as $extra) {
                $data=[
                        'item'=>$extra,
                        'name'=>$name,
                ];
                echo(render_field_extra($data));
            } ?>
        </div>
        <button type="button" class="btn btn-primary btn-block btn-add-extra"><i
                    class="fas fa-plus-square"></i> <?php esc_attr_e('Add extra','wpbookingpro') ?></button>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/assets/less/extra.less');
$doc->addScriptApplySelector('.field-extra','field_extra',array(
    "content_extra"=>  $content_extra,
    "input_name"=>  $name,
    "list_extra"=>  $value,
),'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/extra.jquery.js');