<?php
/**
 * @package     WooBooking.Libraries
 * @subpackage  HTML
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Utility class working with content language select lists
 *
 * @since  1.6
 */
abstract class WpBookingPro_HtmlContentLanguage
{
	/**
	 * Cached array of the content language items.
	 *
	 * @var    array
	 * @since  1.6
	 */
	protected static $items = null;

	/**
	 * Get a list of the available content language items.
	 *
	 * @param   boolean $all True to include All (*)
	 * @param   boolean $translate True to translate All
	 *
	 * @return  string
	 *
	 * @see     JFormFieldContentLanguage
	 * @since   1.6
	 */
	public static function existing($all = false, $translate = false)
	{
		if (empty(static::$items)) {
			// Get the database object and a new query object.
			$db = Factory::getDbo();
			$query = $db->getQuery(true);
			// Build the query.
			$query->select('a.lang_code AS value, a.title AS text, a.title_native')
				->from('#__languages AS a')
				->where('a.published >= 0')
				->order('a.title');
			// Set the query and load the options.
			$db->setQuery($query);
			static::$items = $db->loadObjectList();
		}
		if ($all) {
			$all_option = array(
				new JObject(array(
					'value' => '*',
					'text' => $translate ? WoobookingText::alt('JALL', 'language') : 'JALL_LANGUAGE'
				))
			);
			return array_merge($all_option, static::$items);
		} else {
			return static::$items;
		}
	}
}
