"use strict";
(function ($) {
    $.view_list_rating = function (element, options) {
        let defaults = {
            row_rating_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.add_new_rating = function () {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "rating.ajax_add_new_rating"
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "rating.ajax_save");
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-rating-form').find('.rating-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show');
                            $element.find('.rating-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.edit_rating = function ($tr) {
            var id = $tr.data('id');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "rating.ajax_get_item",
                    id: id
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "rating.ajax_save");
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                        let title = id !== 0 ? `Edit rating: ${id}` : 'Add new rating';
                        $wooBooking.getDrawer().find('h4.title').html(title);
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-rating-form').find('.rating-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show')
                            $element.find('.rating-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.btn-add-rating').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.btn-edit-order').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.pagination-list-rating').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (rating, page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.btn-add-new').click(function (e) {
                plugin.add_new_rating();
            });
            $element.find('.btn-edit-rating').on('click', function (e) {
                let $tr = $(this).closest('tr');
                plugin.edit_rating($tr);
            });
            $element.find('.checked-all').click(function (e) {
                $('table.list-rating').find('.checkbox-item-rating').prop('checked', $(this).is(':checked'));
            });
            $('table.list-rating').find('.checkbox-item-rating').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-rating').find('.checkbox-item-rating');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            let call_back_when_save_success = function (data) {
                var $table_list_rating = $('table.list-rating');
                var $row = $table_list_rating.find(`tr[data-id="${data.id}"]`);
                if ($row.length)
                    $row.find('.name').html(data.name);
                else {
                    $row = $(plugin.settings.row_rating_template);
                    $element.find('.list-rating.main-table').find('tbody').prepend($row);
                }
            };
            $element.find('.btn-delete').click(function (e) {
                let list_delete_rating_id = [];
                $element.find('.checkbox-item-rating:checked').each(function () {
                    list_delete_rating_id.push($(this).val());
                });
                if (list_delete_rating_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please choose rating before delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this rating in gallery ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "rating.ajax_delete",
                                    list_delete_rating_id: list_delete_rating_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $wooBooking.call_back_when_save_success = function (data, is_new) {
                location.reload(true);
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_rating = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_rating')) {
                let plugin = new $.view_list_rating(this, options);
                $(this).data('view_list_rating', plugin);
            }
        });
    }
})(jQuery);
