"use strict";
(function ($) {
    
    $.view_list_event = function (element, options) {
        
        let defaults = {
            
            
            row_event_template: ""
        };
        
        let plugin = this;
        
        plugin.settings = {}
        let $element = $(element); 
        
        plugin.add_new_event = function () {
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "event.ajax_add_new_event"
                },
                beforeSend: function () {
                    $('body').loadingModal();
                    
                },
                error: function (xhr) { 
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);

                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "event.ajax_save");
                        $wooBooking.getDrawer().drawer('toggle');
                        $wooBooking.getDrawer().find('h4.title').html('Add new event');
                        $element.find('.view-event-form').find('.event-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show');
                            $element.find('.event-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                    }
                }
            });
        }
        plugin.edit_event = function ($tr) {
            var id = $tr.data('id');
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "event.ajax_get_item",
                    id: id
                },
                beforeSend: function () {
                    
                    $('body').loadingModal();
                },
                error: function (xhr) { 
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);

                    loadScripts(response);
                    if (response.result === "success") {
                        $wooBooking.getDrawer().find('.drawerEl-content').html(response.data);
                        $('body').append(response.data_script);
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('task', "event.ajax_save");
                        $wooBooking.getDrawer().find('.toolbar-btn-save').data('main_table', "main-table");
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-event-form').find('.event-tab a').on('click', function (e) {
                            e.preventDefault();
                            $(this).tab('show');
                            $element.find('.event-tab a').removeClass('active');
                            $(this).addClass('active');
                        });
                        let $wraper_content=$wooBooking.getDrawer().find('.hy-drawer-content');
                        //$wooBooking.getDrawer().find('.wraper-content >div.bottom').stickyfooterbar($wraper_content);
                    }
                }
            });
        }
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            console.log('kdhfdjf',wpbookingpro_api_task)
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%' 
            });
            $element.find('.btn-add-event').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.btn-edit-order').click(function (e) {
                e.preventDefault();
                $wooBooking.getDrawer().drawer('toggle');
            });
            $element.find('.pagination-list-event').twbsPagination({
                totalPages: 35,
                visiblePages: 7,
                onPageClick: function (event, page) {
                    $('#page-content').text('Page ' + page);
                }
            });
            $element.find('.btn-add-new').click(function (e) {
                plugin.add_new_event();
            });
            $element.find('.btn-edit-event').live('click', function (e) {
                let $tr = $(this).closest('tr');
                plugin.edit_event($tr);
            });
            $element.find('.list-rate-info').slideUp();
            $element.find('.btn-show-rate-detail').click(function (e) {
                let $tr = $(this).closest('tr');
                let event_id = $tr.data('id');
                $tr.nextAll(`.list-rate-info-${event_id}`).slideToggle();
            })
            $element.find('.checked-all').click(function (e) {
                $('table.list-event').find('.checkbox-item').prop('checked', $(this).is(':checked'));
            });
            $('table.list-event').find('.checkbox-item').click(function (e) {
                var checkall = true;
                var $all_checkbox = $('table.list-event').find('.checkbox-item');
                for (let i = 0; i < $all_checkbox.length; i++) {
                    var $checkbox = $($all_checkbox[i]);
                    if (!$checkbox.is(':checked')) {
                        checkall = false;
                    }
                }
                if (checkall) {
                    $element.find('.checked-all').prop('checked', true);
                } else {
                    $element.find('.checked-all').prop('checked', false);
                }
            });
            let call_back_when_save_success = function (data) {
                var $table_list_event = $('table.list-event');
                var $row = $table_list_event.find(`tr[data-id="${data.id}"]`);
                if ($row.length)
                    $row.find('.name').html(data.name);
                else {
                    $row = $(plugin.settings.row_event_template);
                    $element.find('.list-event.main-table').find('tbody').prepend($row);
                }
            };
            $element.find('.btn-Attendees').click(function (e) {
                var id = $(this).data('id');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: wpbookingpro_root_url + wpbookingpro_api_task,
                    data: {
                        action: "get_data",
                        id: id
                    },
                    success: function (response) {
                        
                        $wooBooking.getDrawer().drawer('toggle');
                        $element.find('.view-event-form').find('.event-tab a').on('click', function (e) {
                            e.preventDefault()
                            $(this).tab('show')
                        })
                    }
                });
            });
            $element.find('.btn-delete').click(function (e) {
                let list_delete_event_id = [];
                $element.find('.checkbox-item:checked').each(function (e) {
                    list_delete_event_id.push($(this).val());
                });
                if (list_delete_event_id.length === 0) {
                    $.alert({
                        title: 'Error',
                        content: 'Please select the event to delete!'
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure delete this image in gallery ?',
                    buttons: {
                        confirm: function () {
                            $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: wpbookingpro_root_url + wpbookingpro_api_task,
                                data: {
                                    task: "event.ajax_delete",
                                    list_delete_event_id: list_delete_event_id
                                },
                                success: function (response) {
                                    location.reload(true);
                                }
                            });
                        },
                        cancel: function () {
                        }
                    }
                });
            });
            $wooBooking.call_back_when_save_success = function (data, is_new) {
                location.reload(true);
            }
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    
    $.fn.view_list_event = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('view_list_event')) {
                let plugin = new $.view_list_event(this, options);
                $(this).data('view_list_event', plugin);
            }
        });
    }
})(jQuery);
