<?php 

$query_args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'posts_per_page' => $settings['posts_per_page']
);

$nb_posts = new WP_Query($query_args);
?>

<div class="nb-post-wrapper">
    <?php while ($nb_posts->have_posts()) : $nb_posts->the_post();?>
        <div class="nb-post-item">
            <?php
                $featured_img_url = get_the_post_thumbnail_url(get_the_ID(), 'medium_large ');
            ?>
            <div class="nb-post-thumbnail">
                <a href="<?php the_permalink(); ?>" style="background-image:url(<?php echo $featured_img_url; ?>);"></a>
                <div class="nb-post-date">
                    <span class="nb-post-day"><?php echo date_i18n('j', strtotime(get_the_date(''))); ?></span> 
                    <span class="nb-post-month"><?php echo date_i18n('M', strtotime(get_the_date(''))); ?></span>
                </div>
            </div>

            <div class="nb-post-data">
                <?php the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );?>

                <div class="nb-post-author">
                    <p><?php esc_html_e('By', 'spaclub-elements');?> <?php the_author(); ?></p>
                    <div class="nb-post-date">
                        <span class="nb-post-day"><?php echo date_i18n('j', strtotime(get_the_date(''))); ?></span>
                        <span class="nb-post-month"><?php echo date_i18n('M', strtotime(get_the_date(''))); ?>,</span>
                        <span class="nb-post-year"><?php echo date_i18n('Y', strtotime(get_the_date(''))); ?></span>
                    </div>
                </div>
                <div  class="nb-content">
                    <?php
                    $atts[$limit]=25;
                    if (has_excerpt()) :
                        echo '<p >' . (absint($atts[$limit]) > 0 ? wp_trim_words(get_the_excerpt(), $atts[$limit], '...') : get_the_excerpt()) . '</p>';
                    else :
                        echo '<p>' . (absint($atts[$limit]) > 0 ? wp_trim_words(get_the_content(), $atts[$limit], '...') : get_the_content()) . '</p>';
                    endif;
                    ?>
                </div>


                <div class="read-more-link">
                    <a class="nb-primary-button" href="<?php echo get_permalink(); ?>"><?php echo esc_html__('Read More', 'wp-booking'); ?></a>
                </div>
                
            </div>
        </div>
    <?php endwhile;?>
    <?php wp_reset_postdata();?>
</div>