<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NB_Blog_Elementor extends Widget_Base {

	public function get_name() {
		return 'nb-blog-elementor';
	}

	public function get_title() {
		return __( 'Blog', 'spaclub-elements' );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_categories() {
		return [ 'spaclub-elements' ];
	}

	public function get_script_depends() {
		return [ 'spaclub-elements' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'spaclub-elements' ),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'Posts per page', 'spaclub-elements' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 2,
				'max' => 3,
				'step' => 1,
				'default' => 3,
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$template_path = TP_ELEMENTS_PATH . '/elementor_widgets/blog/template.php';

		require $template_path;
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		?>
		<div class="title">
			{{{ settings.title }}}
		</div>
		<?php
	}
}

\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new NB_Blog_Elementor() );