<?php
/**
 * Plugin Name: WordPress Tour Operator Pro
 * Plugin URI: http://booking.cmsmart.net/
 * Description: TourOperator Pro is a plugin developed for travel agencies and tour operators of all sizes. With this plugin, you can create customized itineraries & travel packages quickly.
 * Version: 1.1.3
 * Author: NetBase Team
 * Author URI: https://netbaseteam.com
 * Text Domain: touroperatorpro
**/

use TourOperatorPro\Application\Application as ApplicationAlias;
use TourOperatorPro\Factory;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Wordpress\WordpressAdmin;

if(!defined('DS')) {
    define("DS",DIRECTORY_SEPARATOR);
}
if (!defined("TOUROPERATORPRO_PLUGIN_NAME")) {
    define('TOUROPERATORPRO_PLUGIN_NAME', pathinfo(__DIR__, PATHINFO_FILENAME));
}
define("TOUROPERATORPRO_PATH_ROOT",plugin_dir_path(__FILE__));
define("_TOUROPERATOR_EXEC",1);
define("TOUROPERATORPRO_PREFIX_TABLE","tbpro_");
define("TOUROPERATORPRO_MINIMUM_ELEMENTOR_VERSION","2.0.0");
define("TOUROPERATORPRO_MINIMUM_PHP_VERSION","7.0");
define("TOUROPERATORPRO_ADMIN_PATH",TOUROPERATORPRO_PATH_ROOT.DS."admin");
define("TOUROPERATORPRO_ADMIN_WOOPANEL_PATH",TOUROPERATORPRO_PATH_ROOT.DS."admin_woopanel");
define("TOUROPERATORPRO_FRONTEND_PATH",TOUROPERATORPRO_PATH_ROOT.DS."frontend");
define("TOUROPERATOR_PLUGIN_DIR_URL",plugin_dir_url(__FILE__));
define("TOUROPERATOR_SITE_URL",get_site_url());
require_once TOUROPERATORPRO_PATH_ROOT.DS."touroperatorconfig.php";
require_once TOUROPERATORPRO_PATH_ROOT.DS."NBAppHelper.php";
// Check for required Elementor version
if(file_exists(ABSPATH . 'wp-content/plugins/elementor/elementor.php'))
{
    include_once( ABSPATH . 'wp-content/plugins/elementor/elementor.php' );
}

/**
 * Class touroperatorpro
 */
class touroperatorpro
{
    function tour_op_generate_rewrite_rules( $wp_rewrite ){

        $wp_rewrite->rules = array_merge(
            ['tour-detail/-53.html' => 'index.php?p=24'],
            $wp_rewrite->rules
        );
    }

    public static function init()
    {
        $url="https://developer.wordpress.org/reference/functions/wp_redirect/";
        require_once __DIR__."/vendor/autoload.php";
        $input= FactoryAlias::getInput();
        $clientId=is_admin()?1:0;
        //check is admin woopanel
        $uri=FactoryAlias::getUri();
        $path=$uri->getPath();
        $data=$input->getData();
        $uri= FactoryAlias::getUri();
        $path=$uri->getPath();

        if(strpos($path,"touroperatorpro_backend")!==false){
            $clientId=1;
        }
        $submit_clientId=$input->getString('submit_clientid',"");
        if($submit_clientId!==""){
            $clientId=(int)$submit_clientId;
        }
        $page="";
        if(strpos($path,"sellercenter")!==false || strpos($path,"touroperatorpro_backend_woopanel")!==false){
            $clientId=2;
            $paths=explode('/',$path);
            foreach ($paths as $a_path){
                if(strpos($a_path,"wb_")!==false){
                    $page=str_replace("wb_","",$a_path);
                }
            }

        }
        $input->set('woopanel_page',$page);
        if($clientId==2){
            require_once __DIR__."/admin_woopanel/includes/defined.php";
        }elseif($clientId==1){
            require_once __DIR__."/admin/includes/defined.php";
        }else{
            require_once __DIR__."/frontend/includes/defined.php";
        }
        $input->set('clientId',$clientId);
        FactoryAlias::setApplicationClient($clientId);
        $app=ApplicationAlias::getInstance($clientId);
        $app->execute();
    }
}

touroperatorpro::init();
if(!function_exists("touroperator_get_content")) {
    function touroperator_render_content($content)
    {
        echo (touroperator_get_content($content));
    }
}
if(!function_exists("touroperator_get_content")) {
    function touroperator_get_content($content)
    {
        return $content;
    }
}





