<?php


namespace TourOperatorPro\Wordpress;

use Exception;

use TourOperatorPro\Factory;

use TourOperatorPro\Language\Text;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Mvc\View\View;


class GutembergBlock
{
    public static $instance=null;
    private $init_GutembergBlock=0;

    public static function getInstance(){
        if (!isset(self::$instance))
        {
            self::$instance=  new GutembergBlock();
        }
        return self::$instance;
    }
    public function __construct()
    {

    }
    public function init()
    {
        if($this->init_GutembergBlock==0) {
            add_action('init', function () {
                $gutembergBlock = GutembergBlock::getInstance();
                $wordpress = Factory::getWordpress();

                $list_view = $wordpress->get_list_layout_block_frontend();
                foreach ($list_view as $key => $item) {
                    $key=str_replace("_","-",$key);
                    register_block_type('touroperatorpro/' . $key, array(
                        'render_callback' => array($gutembergBlock, 'render_gutenberg_dynamic')
                    ));
                }
            });
            $this->init_GutembergBlock=1;
        }
    }
    public function render_gutenberg_dynamic($atts){

        $input=Factory::getInput();
        $open_source_client_id=$atts['open_source_client_id'];
        $blockModel=Model::getInstance('block');
        $block=$blockModel->getBlockByOpenSourceId($open_source_client_id);
        if(!$block){
            return false;
        }
        $input->set('id',$block->id);
        $view=View::getInstance('block');
        $view->view="block";
        echo  ($view->display('preview'));
    }
    function register_block_categories($categories, $post)
    {
        return array_merge(
            $categories,
            array(
                array(
                    'slug' => 'touroperatorpro-block',
                    'title' => Text::_('Tour operator pro block'),
                ),
            )
        );
    }
    function mdlr_editable_block_example_backend_enqueue() {
        $wordpress= Factory::getWordpress(1);
        $list_view = $wordpress->get_list_layout_block_frontend();


        wp_enqueue_script(
            'backend-list-block', // Unique handle.
            plugins_url( 'gutembergBlock/mb-block.js', __FILE__ ),
            array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ),
            filemtime( plugin_dir_path( __FILE__ ) . 'gutembergBlock/mb-block.js' )
        );
        $api_task="/wp-json/".$wordpress::$namespace.$wordpress->get_api_task();
        $api_task_frontend="/wp-json/".$wordpress::$namespace."/".WordpressSite::get_api_task();
        wp_localize_script('backend-list-block', 'list_view', $list_view);
        wp_localize_script('backend-list-block', 'wpbookingpro_root_url', Factory::getRootUrl());
        wp_localize_script('backend-list-block', 'wpbookingpro_root_url_plugin', Factory::getRootUrlPlugin());
        wp_localize_script('backend-list-block', 'wpbookingpro_api_task', $api_task);
        wp_localize_script('backend-list-block', 'wpbookingpro_api_task_frontend', $api_task_frontend);

    }



}