<?php


namespace TourOperatorPro\Utilities;

use touroperatorconfig;
use TourOperatorPro\Factory;
use TourOperatorPro\Crypt\Crypt;
use TourOperatorPro\Language\Text;
use TourOperatorPro\Wordpress\WordpressAdmin;

/**
 * Class Utility
 * @package TourOperatorPro\Utilities
 */
class Utility
{

    /**
     * @param $path
     */
    public static function getListViewFromXml($path)
    {

    }
    public static function redirect($url){
        $root_url= Factory::getRootUrl();
        $html = '<html><head>';
        $html .= '<meta http-equiv="content-type" content="text/html; charset=utf-8" />';
        $html .= '<script>document.location.href=' . json_encode(str_replace("'", '&apos;',$url)) . ';</script>';
        $html .= '</head><body></body></html>';
        echo ($html);
    }

    /**
     * @param $file_path
     * @return mixed
     */
    public static function  get_path_file($file_path){
        return str_replace(TOUROPERATORPRO_PATH_ROOT,"",$file_path);
    }

    /**
     * @param $view_layout
     * @param array $items_var
     * @return string
     */
    public static function getFrontendGoToLink($view_layout, $items_var = array())
    {

        list($view, $layout) = explode(".", $view_layout);
        $http_list_var = array();
        if (is_array($items_var)) {
            foreach ($items_var as $key => $value) {
                $http_list_var[] = "$key=$value";
            }
        } else {
            $http_list_var[] = $items_var;
        }
        $http_string_var = implode("&", $http_list_var);
        $link = Factory::getRootUrl() . "/?page=$view-$layout" . ($http_string_var != "" ? "&$http_string_var" : '');
        return $link;
    }


    /**
     * @param $view_layout
     * @param array $items_var
     * @return string
     */
    public static function getBackendGoToLink($view_layout, $items_var = array())
    {
        $wordpress = Factory::getWordpress(1);
        list($view, $layout) = explode(".", $view_layout);
        $http_list_var = array();
        if (is_array($items_var)) {
            foreach ($items_var as $key => $value) {
                $http_list_var[] = "$key=$value";
            }
        } else {
            $http_list_var[] = $items_var;
        }
        $page = $wordpress->get_format_page($view);
        $http_string_var = implode("&", $http_list_var);
        $link = Factory::getRootUrlBackend() . "/admin.php?page=$page&layout=$layout" . ($http_string_var != "" ? "&$http_string_var" : '');
        return $link;
    }

    public static function getBackendWooPanelGoToLink($view_layout, $items_var = array())
    {
        list($view, $layout) = explode(".", $view_layout);
        $http_list_var = array();
        if (is_array($items_var)) {
            foreach ($items_var as $key => $value) {
                $http_list_var[] = "$key=$value";
            }
        } else {
            $http_list_var[] = $items_var;
        }
        $page="wb_$view";
        $http_string_var = implode("&", $http_list_var);
        $link = \TourOperaTorPro\Factory::getRootUrlBackendWooPanel() . "/$page?layout=$layout" . ($http_string_var != "" ? "&$http_string_var" : '');
        return $link;
    }
    public static function goToTaskByViewWooPanel($view, $task, $items_var = array())
    {
        $wordpress = Factory::getWordpress(2);
        $http_list_var = array();
        if (is_array($items_var)) {
            foreach ($items_var as $key => $value) {
                $http_list_var[] = "$key=$value";
            }
        } else {
            $http_list_var[] = $items_var;
        }
        $page = $wordpress->get_format_page($view);
        $http_string_var = implode("&", $http_list_var);
        $link = Factory::getRootUrlBackendWooPanel() . "/$page?task=$task" . ($http_string_var != "" ? "&$http_string_var" : '');
        return $link;
    }


    /**
     * @param string $table
     * @return string
     */
    public static function getTableName($table = "")
    {
        return TOUROPERATORPRO_PREFIX_TABLE . "$table";
    }

    /**
     * @param $view
     * @param $task
     * @param array $items_var
     * @return string
     */
    public static function goToTaskByView($view, $task, $items_var = array())
    {
        $wordpress = Factory::getWordpress(1);
        $http_list_var = array();
        if (is_array($items_var)) {
            foreach ($items_var as $key => $value) {
                $http_list_var[] = "$key=$value";
            }
        } else {
            $http_list_var[] = $items_var;
        }
        $page = $wordpress->get_format_page($view);
        $http_string_var = implode("&", $http_list_var);
        $link = Factory::getRootUrlBackend() . "/admin.php?page=$page&task=$task" . ($http_string_var != "" ? "&$http_string_var" : '');
        return $link;
    }

    /**
     * @param int $length
     * @return string
     */
    public static function gen_random_string($length = 8)
    {
        $salt = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $base = strlen($salt);
        $makepass = '';

        $random = Crypt::genRandomBytes($length + 1);
        $shift = ord($random[0]);
        for ($i = 1; $i <= $length; ++$i) {
            $makepass .= $salt[($shift + ord($random[$i])) % $base];
            $shift += ord($random[$i]);
        }
        return $makepass;
    }

    /**
     * @param int $length
     * @return string
     */
    public static function gen_random_integer($length = 8)
    {
        $salt = "0123456789";
        $base = strlen($salt);
        $makepass = '';

        $random = Crypt::genRandomBytes($length + 1);
        $shift = ord($random[0]);
        for ($i = 1; $i <= $length; ++$i) {
            $makepass .= $salt[($shift + ord($random[$i])) % $base];
            $shift += ord($random[$i]);
        }
        return $makepass;
    }

    /**
     * @param $file_path
     * @return mixed
     */
    public static function get_short_file_by_path($file_path)
    {

        return str_replace(TOUROPERATORPRO_PATH_ROOT . '/', '', $file_path);
    }

    /**
     * @param $str
     * @return mixed
     */
    public static function remove_string_javascript($str)
    {
        preg_match_all('/<script type=\"text\/javascript">(.*?)<\/script>/s', $str, $estimates);
        return $estimates[1][0];
    }

    /**
     * @param $string
     * @return string|string[]|null
     */
    public static function clean($string)
    {
        return preg_replace('/[^a-zA-Z0-9_ -]/s', '', $string);
    }

    /**
     * @param $string
     * @return string|string[]|null
     */
    public static function clean_all_space_to_single_space($string)
    {
        return preg_replace('/\s+/', ' ', $string);
    }

    /**
     *
     */
    public static function render_message()
    {
        $input = Factory::getInput();
        $client= $input->getInt('clientId', 0);
        $app = Factory::getApplication($client);
        $message = $app->getEnqueueMessage();
        echo "<pre>";
        print_r($message, false);
        echo "</pre>";
    }

    /**
     * @return false|string
     */
    public static function random_string_by_time(){
        //Generate a timestamp using mt_rand.
        $timestamp = mt_rand(1, time());

        //Format that timestamp into a readable date string.
        $randomDate = date("d M Y", $timestamp);

        //Print it out.
        return $randomDate;
    }

    /**
     * @param $fist_name
     * @param $last_name
     * @return string
     */
    public static function get_full_name($fist_name, $last_name)
    {
        return "$fist_name $last_name";
    }

}