<?php
namespace TourOperatorPro\Mvc\Controller;
use TourOperatorPro\Factory;
use TourOperatorPro\Utilities\Utility;
use TourOperatorPro\Mvc\Controller\Controller;

class ControllerFormWooPanel extends Controller
{
    public function add(){
        $this->redirect(\TourOperatorPro\Utilities\Utility::getBackendWooPanelGoToLink($this->view.".form"));
    }
    public function add_payment(){
        $this->redirect(Utility::getBackendWooPanelGoToLink($this->view.".form1"));
    }
    public function edit(){
        $input= \TourOperatorPro\Factory::getInput();
        $id=$input->getInt('id');
        $this->redirect(Utility::getBackendWooPanelGoToLink($this->view.".form",array("id"=>$id)));
    }
    public function save($data = array())
    {
        $data= parent::save($data); // TODO: Change the autogenerated stub
        $this->redirect(Utility::getBackendWooPanelGoToLink($this->view.".list"));
        return true;
    }
    public function cancel($data = array())
    {
        $this->redirect(Utility::getBackendWooPanelGoToLink($this->view.".list"));
        return true;
    }
    public function back_to_list($data = array())
    {
        $this->redirect(Utility::getBackendWooPanelGoToLink($this->view.".list"));
        return true;
    }
    public function apply($data = array())
    {
        $data= parent::save($data); // TODO: Change the autogenerated stub

        $id=$data->id;
        $this->redirect(Utility::getBackendWooPanelGoToLink($this->view.".form",array('id'=>$id)));
        return true;
    }
    public function redirect($url){

        $root_url=Factory::getRootUrl();
        header("location:$url");
        exit();
    }

    public function delete($id = 0)
    {
        $input=Factory::getInput();
        if(!$id)
        {
            $id=$input->getInt('id',0);
        }
        $uri = Factory::getUri();
        $page = explode('/',$uri->getPath());
        $page = substr(end($page), 3);
        $model=$this->getModel();
        $model->delete($id);
        $this->redirect(Utility::getBackendWooPanelGoToLink($page.'.list'));
        return true;
    }
    public function delete_list()
    {
        $input=Factory::getInput();
        $data=$input->getData();
        $items=$data['item'];
        $model=$this->getModel();
        foreach ($items as $id){
            $model->delete($id);
        }
        $uri = Factory::getUri();
        $page = explode('/',$uri->getPath());
        $page = substr(end($page), 3);
        $this->redirect(Utility::getBackendWooPanelGoToLink($page.".list"));
        return true;
    }
    public function clone_list()
    {
        $input=Factory::getInput();
        $data=$input->getData();
        $items=$data['item'];
        $model=$this->getModel();
        foreach ($items as $id){
            $model->duplicate($id);
        }
        $page=$input->getString('page',"");
        $page=str_replace("wb_","",$page);
        $this->redirect(Utility::getBackendWooPanelGoToLink($page.".list"));
        return true;
    }
}