<?php
namespace TourOperatorPro\Mvc\Controller;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Utilities\Utility;

class ControllerForm extends Controller
{
    public function add(){
        $this->redirect(Utility::getBackendGoToLink($this->view.".form"));
    }
    public function edit(){
        $input=Factory::getInput();
        $id=$input->getInt('id');
        $this->redirect(Utility::getBackendGoToLink($this->view.".form",array("id"=>$id)));
    }
    public function save($data = array())
    {
        $data= parent::save($data); // TODO: Change the autogenerated stub
        $clientId=is_admin()?1:0;
        $wordpress=Factory::getWordpress($clientId);
        $this->redirect(Utility::getBackendGoToLink($this->view.".list"));
        return true;
    }
    public function save_v1($data=array()){

        $input=Factory::getInput();
        if(empty($data))
        {
            $data=$input->getData();
        }
        if(empty($data))
        {
            $data=$input->getArray();
        }
        $model=Model::getInstance($this->model);

        $data= $model->save($data);
        return $data;
    }
    public function cancel($data = array())
    {
        $this->redirect(Utility::getBackendGoToLink($this->view.".list"));
        return true;
    }
    public function back_to_list($data = array())
    {
        $this->redirect(Utility::getBackendGoToLink($this->view.".list"));
        return true;
    }
    public function apply($data = array())
    {
        $data= parent::save($data); // TODO: Change the autogenerated stub
        $id=$data->id;
        $clientId=is_admin()?1:0;
        $wordpress=Factory::getWordpress($clientId);
        $this->redirect(Utility::getBackendGoToLink($this->view.".form",array('id'=>$id)));
        return true;
    }
    public function delete($id = 0)
    {
        $input=Factory::getInput();
        if(!$id)
        {
            $id=$input->getInt('id',0);
        }
        $page=$input->getString('page',"");
        $page=str_replace("wb_","",$page);
        $model=$this->getModel();
        $model->delete($id);
        $clientId=is_admin()?1:0;
        $wordpress=Factory::getWordpress($clientId);
        $this->redirect(Utility::getBackendGoToLink($page.".list"));
        return true;
    }
    public function delete_list()
    {
        $input=Factory::getInput();
        $data=$input->getData();
        $items=$data['item'];
        $model=$this->getModel();
        foreach ($items as $id){
            $model->delete($id);
        }
        $page=$input->getString('page',"");
        $page=str_replace("wb_","",$page);
        $this->redirect(Utility::getBackendGoToLink($page.".list"));
        return true;
    }
    public function clone_list()
    {
        $input=Factory::getInput();
        $data=$input->getData();
        $items=$data['item'];
        $model=$this->getModel();
        foreach ($items as $id){
            $model->duplicate($id);
        }
        $page=$input->getString('page',"");
        $page=str_replace("wb_","",$page);
        $this->redirect(Utility::getBackendGoToLink($page.".list"));
        return true;
    }
}