<?php
namespace TourOperatorPro\Html;
use TourOperatorPro\Factory;

/**
 * Class TourOperatorProHtmlBackend
 * @package TourOperatorPro\Html
 */
class TourOperatorProHtmlBackend
{
    /**
     * @var array
     */
    private static $loaded = array();

    /**
     * @param $key
     */
    public static function load_jquery_library($key)
    {
        static::call($key);
    }

    /**
     *
     */
    public static function less()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/less/less.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }
    public static function lazy_load()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/jquery.lazy/jquery.lazy.js");
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function ckeditor()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("admin/resources/ckeditor_4.14.1_full/ckeditor/ckeditor.js");
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function fullcalendar($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/fullcalendar/core/main.min.css');
            $doc->addStyleSheet('admin/resources/fullcalendar/daygrid/main.min.css');
            $doc->addStyleSheet('admin/resources/fullcalendar/timegrid/main.min.css');
            $doc->addStyleSheet('admin/resources/fullcalendar/bootstrap/main.min.css');
            $doc->addScript('admin/resources/fullcalendar/core/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/daygrid/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/timegrid/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/bootstrap/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/interaction/main.min.js');
            $doc->addScript('admin/resources/fullcalendar/moment/main.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function awesome()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/fontawesome-free-5.12.1/css/all.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function chart_js($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/Chart_js/Chart.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function bootstrap_tabs($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/Bootstrap-Tabs/jquery.responsivetabs.js');
            $doc->addScript('admin/resources/Bootstrap-Tabs/bootstrap4/jquery.responsivetabs.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function datatables()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript("https://cdn.datatables.net/1.10.20/js/jquery.dataTables.js");
            $doc->addStyleSheet('https://cdn.datatables.net/v/dt/dt-1.10.20/datatables.min.css');
            $doc->addStyleSheet('https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }
    public static function datepickertime($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/bootstrap-datetimepicker-master/css/bootstrap-datetimepicker.css');
            $doc->addScript('admin/resources/bootstrap-datetimepicker-master/js/bootstrap-datetimepicker.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function dateselect($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/DateSelect/css/jquery.dateselect.css');
            $doc->addScript('admin/resources/DateSelect/js/jquery.dateselect.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function fontawesome($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/fontawesome-free-5.12.1/css/all.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function sortable_master()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript("admin/resources/sortable-master/dist/table-sortable.js");
            $doc->addStyleSheet('admin/resources/sortable-master/dist/styles.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function icheck()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript("admin/resources/icheck-1.x/icheck.js");
            $doc->addStyleSheet('admin/resources/icheck-1.x/skins/all.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function tooltip()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function select_yes_no()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/Toggle-Switches/lc_switch.js');
            $doc->addStyleSheet('admin/resources/Toggle-Switches/lc_switch.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function tooltipster()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/tooltipster/dist/js/tooltipster.bundle.min.js');
            $doc->addStyleSheet('admin/resources/tooltipster/dist/css/tooltipster.bundle.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function main_app()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScriptApplySelector('body', 'view_main_app', array(), 'admin/app/assets/js/view_main_app.js');
            $doc->addLessStyleSheet('admin/app/assets/less/view_main_app.less');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function loading_js($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/Fullscreen-Loading-Modal-Indicator/css/jquery.loadingModal.css');
            $doc->addScript('admin/resources/Fullscreen-Loading-Modal-Indicator/js/jquery.loadingModal.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function waitingfor($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/Bootstrap-Loading/src/waitingfor.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function debug($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/app/assets/js/woo_booking_debug.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function ui_progress_bar($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/ui-progress-bar/javascripts/progress.js');
            $doc->addStyleSheet('admin/resources/ui-progress-bar/stylesheets/ios.css');
            $doc->addStyleSheet('admin/resources/ui-progress-bar/stylesheets/ui.css');
            $doc->addStyleSheet('admin/resources/ui-progress-bar/stylesheets/ui.progress-bar.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }


    /**
     *
     */
    function my_custom_script_load(){
        wp_enqueue_script( 'my-custom-script', TOUROPERATOR_PLUGIN_DIR_URL.'admin/app/assets/js/touroperatorpro_form.js', array( 'jquery' ) );
    }

    /**
     *
     */
    public static function bootstrap()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/bootstrap3.3.7/bootstrap.min.css');
            $doc->addScript('admin/resources/bootstrap3.3.7/bootstrap.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function confirm()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('admin/resources/jquery-confirm-master/dist/jquery-confirm.min.css');
            $doc->addScript('admin/resources/jquery-confirm-master/dist/jquery-confirm.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function auto_numeric($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/autoNumeric/autoNumeric.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param array $components
     * @param null $debug
     */
    public static function ui(array $components = array('core'), $debug = null)
    {
        // Set an array containing the supported jQuery UI components handled by this method
        $supported = array('core', 'sortable');

        $doc = Factory::getDocument();
        $doc->addScript('admin/resources/jquery-ui-1.11.3/jquery-ui.js');
        $doc->addStyleSheet('admin/resources/jquery-ui-1.11.3/jquery-ui.css');
        return;
    }

    /**
     * @param null $debug
     */
    public static function select2($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/select2-4.0.12/dist/js/select2.full.min.js');
            $doc->addStyleSheet('admin/resources/select2-4.0.12/dist/css/select2.min.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function daterangepicker($debug = null)
    {
        static::moment();
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/daterangepicker-master/daterangepicker.js');
            $doc->addStyleSheet('admin/resources/daterangepicker-master/daterangepicker.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function moment($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('admin/resources/moment/moment.js');
            $doc->addScript('admin/resources/moment/moment-with-locales.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }


    /**
     * @param $function
     */
    protected static function call($function)
    {
        call_user_func(array("TourOperatorPro\Html\TourOperatorProHtmlBackend", $function));
    }

    /**
     * @param $tile
     * @return false|string
     */
    public static function render_toolbar($tile)
    {
        ob_start();
        ?>
        <div class="toolbar">
            <div class="row">
                <div class="col-12">
                    <div class="float-left"><h3><?php esc_attr_e($tile); ?></h3></div>
                    <div class="float-right">
                        <button type="button" class="btn btn-primary btn-tour-operator-pro-submit btn-add-new" data-task="save">Add New</button>
                        <button type="button" class="btn btn-primary btn-tour-operator-pro-submit btn-edit" data-task="edit">Edit</button>
                        <button type="button" class="btn btn-primary btn-tour-operator-pro-submit btn-remove" data-task="delete">Remove</button>
                    </div>
                </div>
            </div>
        </div>
        <?php
        $content = ob_get_clean();
        return $content;
    }
}