<?php
namespace TourOperatorPro\Html;

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;

/**
 * Class ToolBar
 * @package TourOperatorPro\Html
 */
class ToolBar
{
    /**
     * @var array
     */
    public static $list_button=array();
    /**
     * @var
     */
    private static $title;
    /**
     * @var string
     */
    private static $layout_edit="form";

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function save($task="save", $icon="fas fa-save", $alt="Save", $tooltip="save")
    {
        ob_start();
        ?>
        <button class="btn btn-primary btn-tour-operator-pro-submit" type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function apply($task="apply", $icon="fas fa-save", $alt="Apply", $tooltip="Apply")
    {
        ob_start();
        ?>
        <button class="btn btn-primary btn-tour-operator-pro-submit" type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function add($task="add", $icon="fas fa-plus", $alt="Add", $tooltip="Add")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-tour-operator-pro-submit"  type="button"  data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param bool $must_select
     * @param string $class_checkbox
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     * @return false|string
     */
    public static function edit($task="edit", $must_select=true, $class_checkbox="item", $icon="fas fa-edit", $alt="Edit", $tooltip="Edit")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-tour-operator-pro-submit" data-class_checkbox="<?php echo ($class_checkbox) ?>"  type="button" data-must_selected="<?php echo ($must_select?1:0); ?>" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        return $content;
    }

    /**
     * @param $task
     * @param $alt
     * @param string $tooltip
     * @param string $icon
     * @return false|string
     */
    public static function render_button_task($task, $alt, $tooltip="", $icon="fas fa-edit")
    {
        ob_start();
        ?>
        <button class="btn btn-info btn-tour-operator-pro-submit"   type="button" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        return $content;
    }

    /**
     * @param string $task
     * @param bool $must_select
     * @param string $class_checkbox
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function delete($task="delete_list", $must_select=true, $class_checkbox="item", $icon="fas fa-trash-alt", $alt="Delete", $tooltip="Delete")
    {
        $msg="Are you sure you want this action ?";
        ob_start();
        ?>
        <button class="btn btn-danger btn-tour-operator-pro-submit" data-class_checkbox="<?php echo ($class_checkbox) ?>"  type="button" data-must_selected="<?php echo ($must_select?1:0); ?>" data-msg_config="<?php esc_attr_e($msg); ?>" type="button" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param bool $must_select
     * @param string $class_checkbox
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function _clone($task="clone_list", $must_select=true, $class_checkbox="item", $icon="fa fa-clone", $alt="Clone", $tooltip="Clone")
    {
        $msg="Are you sure you want this action ?";
        ob_start();
        ?>
        <button class="btn btn-danger btn-tour-operator-pro-submit" data-class_checkbox="<?php echo ($class_checkbox) ?>"  type="button" data-must_selected="<?php echo ($must_select?1:0); ?>" data-msg_config="<?php esc_attr_e($msg); ?>" type="button" data-task="<?php esc_attr_e($task); ?>" title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function cancel($task="cancel", $icon="fas fa-undo-alt", $alt="Cancel", $tooltip="Cancel")
    {

        ob_start();
        ?>
        <button class="btn btn-danger btn-tour-operator-pro-submit" data-task="<?php esc_attr_e($task); ?>" type="button"  title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param string $task
     * @param string $icon
     * @param string $alt
     * @param string $tooltip
     */
    public static function back_to_list($task="back_to_list", $icon="fa fa-list", $alt="Back", $tooltip="Back")
    {
        ob_start();
        ?>
        <button class="btn btn-danger btn-tour-operator-pro-submit" data-task="<?php esc_attr_e($task); ?>" type="button"  title="<?php esc_attr_e($tooltip); ?>"><i class="<?php esc_attr_e($icon); ?>" aria-hidden="true"></i> <?php esc_attr_e($alt); ?></button>
        <?php
        $content=ob_get_clean();
        self::$list_button[]=$content;
    }

    /**
     * @param $title
     */
    public static function setTitle($title){
        static::$title=$title;
    }

    /**
     * @return false|string
     */
    public static function render_toolbar(){
        $list=self::$list_button;
        ob_start();
        ?>
        <div class="toolbar">
            <div class="row">
                <div class="col-md-12">
                    <div class="title pull-left"><h3 class="title"><?php esc_html_e(static::$title) ?></h3></div>
                    <div class="controllers pull-right">
                        {content}
                    </div>
                </div>
            </div>
        </div>
        <?php
        $content=ob_get_clean();
        $content=str_replace('{content}',implode(" ",$list),$content);
        self::$list_button[]=$content;
        return $content;
    }

    /**
     * @param string $layout
     */
    public static function setLayoutEdit(string $layout)
    {
        static::$layout_edit=$layout;
    }
}