<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace TourOperatorPro\Form\fields;
defined('_TOUROPERATOR_EXEC') or die;
use TourOperatorPro\Form\FormField;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingPro_FormFieldUploadsystem extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'uploadsystem';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.uploadsystem.uploadsystem';
    /**
     * Method to get the data to be passed to the layout for rendering.
     *
     * @return  array
     *
     * @since 3.7
     */
    protected function getLayoutData()
    {
        $data = parent::getLayoutData();
        /* Get the field options for the datalist.
            Note: getSuggestions() is deprecated and will be changed to getOptions() with 4.0. */

        $extraData = array(
            'name_field_deleted'   => $this->element['name_field_deleted'],
            'enable_upload'   => $this->element['enable_upload'],
        );

        return array_merge($data, $extraData);
    }

}
