<?php
namespace TourOperatorPro;
use http\Client;
use NBAppHelper;
use RuntimeException;
use touroperatorconfig;
use TourOperatorPro\Application\Application as ApplicationAlias;
use TourOperatorPro\Document\Document;
use TourOperatorPro\FOFInput\FOFInput;
use TourOperatorPro\Language\Language;
use TourOperatorPro\Registry\Registry;
use TourOperatorPro\Uri\NBUri;
use TourOperatorPro\WbDate\WbDate;
use TourOperatorPro\Wordpress\Wordpress;
use TourOperatorPro\Database\driver\DatabaseDriverMysqli;

/**
 * Class Factory
 * @package TourOperatorPro
 */
class Factory
{

    private static $input;
    private static $application;
    public static $client;
    private static $document;
    private static $dates;
    private static $open_source=null;

    public static function getInput()
    {
        if (!self::$input) {
            self::$input = new FOFInput();
        }
        return self::$input;
    }
    public static function getApplication($client=0)
    {
        if (!self::$application) {

            self::$application = ApplicationAlias::getInstance($client);
        }

        return self::$application;
    }

    public static function getApplicationClient(){
        return static::$client;
    }
    public static function setApplicationClient($client){
        static::$client=$client;
    }

    public static function getConfig(){
        $file=TOUROPERATORPRO_PATH_ROOT.DS."touroperatorconfig.php";
        if (is_file($file))
        {
            include_once $file;
        }
        $registry = new Registry;
        $config= new touroperatorconfig();
        $registry->loadObject($config);

        return $registry;
    }
    public static function getDocument():Document
    {
        if (!isset(static::$document)) {
            static::$document = new Document();
        }
        return static::$document;
    }

    public static function getWordpress($client=0):Wordpress
    {
        $app=ApplicationAlias::getInstance($client);
        return $app->getWordpress();

    }
    public static function getDate($time = 'now', $tzOffset = null)
    {
        if (!isset(self::$dates[$time]))
        {
            self::$dates[$time] = new WbDate($time, $tzOffset);
        }

        $date = clone self::$dates[$time];
        return $date;
    }

    public static function getRootUrlPlugin()
    {
        return TOUROPERATOR_PLUGIN_DIR_URL;
    }

    public static function getRootUrl()
    {
        return TOUROPERATOR_SITE_URL;
    }
    public static function getRootUrlBackend()
    {
        return TOUROPERATOR_SITE_URL."/wp-admin";
    }
    public static function getRootUrlBackendWooPanel()
    {
        return TOUROPERATOR_SITE_URL."/sellercenter";
    }
    public static function getDBO()
    {
        $host = DB_HOST;
        $user = DB_USER;
        $password = DB_PASSWORD;
        $database = DB_NAME;
        $prefix = "";
        $driver = "mysqli";
        $debug = true;
        $options = array('driver' => $driver, 'host' => $host, 'user' => $user, 'password' => $password, 'database' => $database, 'prefix' => $prefix);


        try {
            $db = DatabaseDriverMysqli::getInstance($options);
        } catch (RuntimeException $e) {
            if (!headers_sent()) {
                header('HTTP/1.1 500 Internal Server Error');
            }
            exit('Database Error: ' . $e->getMessage());
        }

        $db->setDebug($debug);
        return $db;
    }

    public static function getSession()
    {
    }

    public static function getAppConfig()
    {
        $db=Factory::getDBO();
        $query=$db->getQuery(true);
        $query->select("*")
            ->from(TOUROPERATORPRO_PREFIX_TABLE."config")
            ->where('id=1')
        ;
        $item=$db->setQuery($query)->loadObject();
        $param=$item->params;
        $reg=new Registry();
        $reg->loadString($param);
        return $reg;
    }

    public static function getUri($url="")
    {
        if($url!=="")
        {
            $uri=NBUri::getInstance($url);
        }else{
            $uri=NBUri::getInstance();
        }
        return $uri;
    }
    public static function getUser()
    {
        
        $data1= wp_get_current_user();
       
        $user=$data1->data;
        if(!isset($user->ID)){
            return false;
        }
        $user->id=$user->ID;
        $user->username=$user->user_login;
        return $user;
    }
    public static function getLanguage()
    {
        $conf = self::getConfig();
        $locale = $conf->get('language');
        $debug = $conf->get('debug_lang');
        $lang = Language::getInstance($locale, $debug);
        return $lang;
    }
    public static function getOpenSource($clientId){
        if (!isset(self::$open_source[$clientId]))
        {

            self::$open_source[$clientId] = Wordpress::getInstance($clientId);
        }
        return self::$open_source[$clientId];
    }
}