<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Database
 *
 *  Copyright (C) 2005 - 2016 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

namespace TourOperatorPro\Database\exporter;
use Exception;
use TourOperatorPro\Database\driver\DatabaseDriverMysql;
use TourOperatorPro\Language\Text;

defined('_TOUROPERATOR_EXEC') or die;

/**
 * MySQL export driver.
 *
 * @since       11.1
 * @deprecated  Will be removed when the minimum supported PHP version no longer includes the deprecated PHP `mysql` extension
 */
class DatabaseExporterMysql extends DatabaseExporterMysqli
{
    /**
     * Checks if all data and options are in order prior to exporting.
     *
     * @return  DatabaseExporterMysql  Method supports chaining.
     *
     * @throws  Exception if an error is encountered.
     * @since   11.1
     */
    public function check()
    {
        // Check if the db connector has been set.
        if (!($this->db instanceof DatabaseDriverMysql)) {
            throw new Exception(Text::_(Text::_('PLATFORM_ERROR_DATABASE_CONNECTOR_WRONG_TYPE')));
        }
        // Check if the tables have been specified.
        if (empty($this->from)) {
            throw new Exception('PLATFORM_ERROR_NO_TABLES_SPECIFIED');
        }
        return $this;
    }
}
