<?php
namespace TourOperatorProBlock\block_tour_popular_in_month;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Wordpress\TBPRO_Widget_Base;
use TourOperatorPro\Wordpress\TBPRO_Widget_Base_Interface;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class CategoriesWidget
 */
class tour_popular_in_monthWidget  extends TBPRO_Widget_Base
{

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    public function get_name() {

        return  "tour_popular_in_month";
    }
    public function get_title() {

        return  "Tour popular in month";
    }
    protected function _register_controls() {
        $modelTour_type=Model::getInstance('tourtype');
        $list_tourtype=$modelTour_type->getList();
        $option=array();
        $option[0]= esc_html('Select all', 'touroperatorpro' );
        foreach ($list_tourtype as $tourtype){
            $option[$tourtype->id]= esc_html( $tourtype->name );
        }


        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html('Content', 'touroperatorpro' ),
            ]
        );
        $this->add_control(
            'filter_by_tour_type',
            [
                'label' => esc_html('Filter by tour type', 'touroperatorpro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 0,
                'options' =>$option,
                'selectors' => [
                    '{{WRAPPER}} .tour_type' => 'tour type: {{VALUE}};',
                ],
            ]
        );



        $modelDestination=Model::getInstance('destinations');
        $list_destination=$modelDestination->getList();
        $option=array();
        $option[0]= esc_html('Select all', 'touroperatorpro' );
        foreach ($list_destination as $destination){
            $option[$destination->id]= esc_html( $destination->name );
        }

        $this->add_control(
            'filter_by_destination',
            [
                'label' => esc_html('Filter by destination', 'touroperatorpro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 0,
                'options' =>$option,
                'selectors' => [
                    '{{WRAPPER}} .destination' => 'destination: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html('Style', 'touroperatorpro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->end_controls_section();
    }


    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return [ 'touroperatorpro' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    public function get_data_config($settings) {
        $data_setting=new \stdClass();
        $data_setting->filter_by_tour_type=$settings['filter_by_tour_type'];
        $data_setting->filter_by_destination=$settings['filter_by_destination'];
        return $data_setting;
    }


}
