<?php
use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
?>
<div class="block_tour_popular_in_month">
    <div id="owl-carousel" class="owl-carousel owl-theme">
            <?php foreach ($list_tour as $item) { ?>
                <?php
                $new_price = $item ->price;
                if($item->discount) {
                    if($item->discount->amount > 0) {
                        $new_price = $item->price - $item->discount->amount;
                    } else if ($item->discount->percent > 0) {
                        $new_price= $item->price - ($item->price * $item->discount->percent) / 100 ;
                    }
                }
                $max_star = 5;
                $item_rating=$item->rating;
                while ($item_rating > $max_star) {
                    $item_rating = $item_rating - $max_star;
                }

                $star = $item_rating % 10;
                $non_star = ($max_star - $item_rating) % 10;
                $half_star = ceil($max_star-$star-$non_star);
                ?>
                <div class="block-tour-item">
                    <div class="content-top">
                        <div class="block-img">
                            <div>
                                <img class="lazy" data-src="<?php echo (Factory::getRootUrlPlugin());?><?php echo ($item->image);?>" >
                            </div>
                        </div>
                        <div class="block-feature">
                            <div class="label-feature <?php esc_attr_e($item->is_feature==1 ? 'visible':'');?>">
                                <span><?php esc_attr_e('Featured','touroperatorpro');?></span>
                            </div>
                            <i class="fas fa-heart"></i>
                        </div>
                        <?php if($item->discount) {?>
                            <?php if($item->discount->amount > 0) {?>>
                                <span class="box-sale">- $<?php esc_html_e($item->discount->amount);?></span>
                            <?php } if($item->discount->percent > 0) {?>
                                <span class="box-sale"><?php esc_html_e($item->discount->percent);?>%</span>
                            <?php }?>
                        <?php }?>
                    </div>
                    <div class="content-bottom">
                        <p class="place-tour">
                            <i class="icon-nb-pin"></i>
                            <?php
                            if(isset(end($item->list_destination)->address)){
                                esc_html_e(end($item->list_destination)->address);
                            }
                            ?>
                        </p>
                        <h4 class="name-tour">
                            <a href="<?php echo($this->page_tour_detail.'?tour_id='.$item->id); ?>">
                                <?php esc_html_e($item->name);?>
                            </a>
                        </h4>
                        <div class="block-rating">
                            <ul class="list-rating-star">
                                <?php if($item->rating > 0) {?>
                                    <?php for ($i=0; $i <$star; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$half_star; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$non_star; $i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                <?php }?>
                            </ul>
                            <div class="rating-review">
                                <span>2 <?php esc_attr_e('Reviews','touroperatorpro');?></span>
                            </div>
                        </div>
                        <div class="block-price-sale">
                            <?php if($item->discount) {?>
                                <span><?php esc_html_e((FrontendHelper::format_currency(number_format((float)$item->price,2))));?></span>
                            <?php } else {?>
                                <span></span>
                            <?php }?>
                        </div>
                        <div class="block-trip-price">
                            <div class="time-trip">
                                <i class="icon-nb-clock"></i>
                                <span><?php echo ($item->duration);?> <?php esc_attr_e('Days','touroperatorpro');?></span>
                            </div>
                            <div class="price-tour">
                                <span><i class="fas fa-bolt"></i><span><?php esc_attr_e('From','touroperatorpro');?></span></span>
                                <span class="price"><?php esc_html_e(FrontendHelper::format_currency(number_format((float)$new_price,2)));?></span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_tour_popular_in_month/assets/less/block_tour_popular_in_month.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addStyleSheet('frontend/resources/fontawesome-free-5.12.1/css/all.css');
$doc->addScriptApplySelector('.block_tour_popular_in_month','block_tour_popular_in_month',array(),'frontend/blocks/block_tour_popular_in_month/assets/js/block_tour_popular_in_month.js');
