<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$page_tour_detail = ConfigHelperAlias::get_page_tour_detail();
$this->page_tour_detail = get_page_link($page_tour_detail);
?>
<div class="block_tour_destination">
    <div id="owl-carousel" class="owl-carousel owl-theme">
        <?php foreach ($list_tour as $item) { ?>
            <div class="item">
                <a class="img-block" href="<?php echo($this->page_tour_detail . '?tour_id=' . $item->id); ?>">
                    <div>
                        <img  class="image lazy" data-src="<?php echo(Factory::getRootUrlPlugin().'/'.$item->image) ?>" alt="tour-image">
                    </div>
                </a>
                <div class="price">
                    <p>$<?php esc_html_e($item->price); ?> /<span><?php esc_attr_e('Person','touroperatorpro'); ?></span></p>
                </div>
            </div>
        <?php } ?>
    </div>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_tour_destination/assets/less/block_tour_destination.less');
$doc->addScriptApplySelector('.block_tour_destination','block_tour_destination',array(),'frontend/blocks/block_tour_destination/assets/js/block_tour_destination.js');
