<?php
namespace TourOperatorProBlock\block_top_tour;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProFrontend\app\helpers\FrontendHelper;

class block_top_tour_helper{
    public static function getList_tour(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('DISTINCT tour.*')
            ->from(UtilityAlias::getTableName('tour').' AS tour ')
            ->leftJoin(UtilityAlias::getTableName('tourproperty').' AS tour_property ON tour_property.tour_id=tour.id')
            ->where('tour.published=1')
            ->where('tour.is_top_tour=1')

        ;
        $list=$db->setQuery($query)->loadObjectList();
        foreach ($list as &$tour){
            $query->clear()
                ->select('DISTINCT tourtype.*')
                ->from(UtilityAlias::getTableName('tourproperty').' AS tourproperty')
                ->leftJoin(UtilityAlias::getTableName('tourtype').' AS tourtype ON tourtype.id=tourproperty.object_id')
                ->where('tour_id='.(int)$tour->id)
                ->where('type='.$query->quote(FrontendHelper::getTourTypeKey()))
            ;
            $list_tour_type= $db->setQuery($query)->loadObjectList();
            $tour->list_tour_type=$list_tour_type;

            $query->clear()
                ->select('wishlist.user_id')
                ->from(UtilityAlias::getTableName('wishlist').' AS wishlist')
                ->where('tour_id='.(int)$tour->id)
            ;
            $tour->user_wishlist = $db->setQuery($query)->loadColumn();

            $query->clear()
                ->select('DISTINCT location.*')
                ->from(UtilityAlias::getTableName('tourproperty').' AS tourproperty')
                ->leftJoin(UtilityAlias::getTableName('location').' AS location ON location.id=tourproperty.object_id')
                ->where('tour_id='.(int)$tour->id)
                ->where('type='.$query->quote(FrontendHelper::getTourDestinationKey()))
            ;
            $list_destination= $db->setQuery($query)->loadObjectList();
            $tour->list_destination=$list_destination;

            $query->clear()
                ->select('DISTINCT discount.*')
                ->from(UtilityAlias::getTableName('tourproperty').' AS tourproperty')
                ->leftJoin(UtilityAlias::getTableName('discount').' AS discount ON discount.id=tourproperty.object_id')
                ->where('tour_id='.(int)$tour->id)
                ->where('type='.$query->quote(FrontendHelper::getTourDiscountKey()))
            ;
            $list_discount= $db->setQuery($query)->loadObjectList();
            $tour->discount= reset($list_discount);
        }
        return $list;
    }
}