<?php
namespace TourOperatorProBlock\block_top_destination;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Wordpress\TBPRO_Widget_Base;
use TourOperatorPro\Wordpress\TBPRO_Widget_Base_Interface;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class CategoriesWidget
 */
class top_destinationWidget  extends TBPRO_Widget_Base
{

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    public function get_name() {

        return  "top_destination";
    }
    public function get_title() {

        return  "Top destination";
    }
    public function get_data_config($settings) {
        $data_setting=new \stdClass();
        $data_setting->limit=$settings['limit'];
        $data_setting->layout_block=$settings['layout_block'];
        $data_setting->show_name=$settings['show_name'];
        $data_setting->show_price=$settings['show_price'];
        $data_setting->show_number_tour=$settings['show_number_tour'];
        $data_setting->show_star=$settings['show_star'];
        $data_setting->show_btn_link=$settings['show_btn_link'];
        $data_setting->show_btn_eye=$settings['show_btn_eye'];
        return $data_setting;
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_attr('Content', 'touroperatorpro' ),
            ]
        );
        $this->add_control(
            'layout_block',
            [
                'label' => __( 'Layout', 'touroperatorpro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => array(
                    'default' => __('Default', 'touroperatorpro'),
                    'slider' => __('Slider', 'touroperatorpro'),
                ),
                'frontend_available' => true,
            ]
        );
        $this->add_control(
            'show_name',
            [
                'label' => __( 'Show Name', 'touroperatorpro'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __( 'Hide', 'touroperatorpro'),
                'label_on' => __( 'Show', 'touroperatorpro'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_price',
            [
                'label' => __( 'Show Price', 'touroperatorpro'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __( 'Hide', 'touroperatorpro'),
                'label_on' => __( 'Show', 'touroperatorpro'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_number_tour',
            [
                'label' => __( 'Show Number Tour', 'touroperatorpro'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __( 'Hide', 'touroperatorpro'),
                'label_on' => __( 'Show', 'touroperatorpro'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_star',
            [
                'label' => __( 'Show Star', 'touroperatorpro'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __( 'Hide', 'touroperatorpro'),
                'label_on' => __( 'Show', 'touroperatorpro'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_btn_link',
            [
                'label' => __( 'Show Link', 'touroperatorpro'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __( 'Hide', 'touroperatorpro'),
                'label_on' => __( 'Show', 'touroperatorpro'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_btn_eye',
            [
                'label' => __( 'Show Eye', 'touroperatorpro'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __( 'Hide', 'touroperatorpro'),
                'label_on' => __( 'Show', 'touroperatorpro'),
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'limit',
            [
                'label' => __( 'Limit', 'touroperatorpro' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 0,
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_attr('Style', 'touroperatorpro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->end_controls_section();
    }


    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return [ 'touroperatorpro' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */


}
