<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Html\TourOperatorProHtmlBackend;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\FrontendHelper;
use TourOperatorProFrontend\app\Html\HtmlFrontend;

TourOperatorProHtmlBackend::load_jquery_library('fontawesome');
?>
<div class="block_top_destination">
    <div id="owl-carousel" class="owl-carousel owl-theme">
        <?php foreach ($list_destination as $destination) {?>
            <div class="block-destination-item">
                <div class="content-top">
                    <div class="img-block">
                        <div>
                            <img src="<?php echo (Factory::getRootUrlPlugin())?><?php esc_html_e(isset($destination->image_location_avatar)?$destination->image_location_avatar:'');?>" alt="image-destination-popular">
                        </div>
                    </div>
                </div>
                <div class="content-bottom">
                    <h4 class="destination-name"><?php esc_html_e(isset($destination->name)?$destination->name:'');?></h4>
                    <p class="price">
                        <span><?php esc_html_e('Starting from');?>:</span>
                        <span class="price-detail"><?php esc_html_e(HtmlFrontend::render_price(isset($destination->price_from)?$destination->price_from:''))?></span>
                    </p>
                </div>
            </div>
        <?php }?>

    </div>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_top_destination/assets/less/block_top_destination.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block_top_destination','block_top_destination',array(

),'frontend/blocks/block_top_destination/assets/js/block_top_destination.js');
