<?php
namespace TourOperatorProBlock\block_top_destination;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProFrontend\app\helpers\FrontendHelper;

class block_top_destination_helper{
    public static function getList_destination($limit){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('DISTINCT location.*')
            ->from(UtilityAlias::getTableName('location') . ' AS location')
            ->where('location.is_popular_destination=1')
            ->where('location.published=1')
            ;
        $list = $db->setQuery($query,0,$limit)->loadObjectList();

        foreach ($list as &$item) {
            $query->clear()
                ->select('DISTINCT tour.id')
                ->from(UtilityAlias::getTableName('tour').' AS tour')
                ->leftJoin(UtilityAlias::getTableName('tourproperty').' AS tourproperty ON tourproperty.tour_id=tour.id')
                ->where('tourproperty.object_id='.(int)$item->id)
                ->where('tourproperty.type='.$query->quote(FrontendHelper::getTourDestinationKey()))
                ;
            $list_tour = $db->setQuery($query)->loadObjectList();
            $item->number_tour= count($list_tour);
        }
        return $list;
    }
}