<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$page_tour_detail = ConfigHelperAlias::get_page_tour_detail();
$this->page_tour_detail = get_page_link($page_tour_detail);
?>
<div class="block_testimonial_carousel">
    <div class="contain">
        <div id="owl-carousel" class="owl-carousel owl-theme">
            <?php foreach ($list_tour as $item) { ?>
                <div class="item">
                    <a href="<?php echo($this->page_tour_detail . '?tour_id=' . $item->id); ?>"><img
                                class="image lazy"
                                data-src="<?php echo(Factory::getRootUrlPlugin().'/'.$item->image) ?>"></a>
                    <div class="price">
                        <p>$<?php esc_html_e($item->price); ?> /<span><?php esc_attr_e('Person','touroperatorpro'); ?></span></p>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_testimonial_carousel/assets/less/block_testimonial_carousel.less');
$doc->addScriptApplySelector('.block_testimonial_carousel','block_testimonial_carousel',array(),'frontend/blocks/block_testimonial_carousel/assets/js/block_testimonial_carousel.js');
