<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
?>

<div class="block-search-tour">
    <form action="<?php echo($page_list_tour_search_result)  ?>" class="form-search" method="get">
        <div class="block-select-destination">
            <i class="icon-nb-pin"></i>
            <label><?php esc_attr_e('Destination','touroperatorpro');?></label>
            <select name="destination" class="select-destination">
                <option value=""><?php esc_attr_e('Where are you going','touroperatorpro');?></option>
                <?php foreach ($list_country as $country) {?>
                    <optgroup label="<?php esc_attr_e($country->countryname);?>">
                        <?php foreach ($country->list_location as $location) {?>
                            <option value="<?php esc_attr_e($location->location_id);?>"><?php esc_html_e($location->location_name);?></option>
                        <?php }?>
                    </optgroup>
                <?php }?>
            </select>
        </div>
        <div class="block-select-date"> 
            <i class="icon-nb-calendar"></i>
            <label for=""><?php esc_attr_e('From','touroperatorpro');?>-<?php esc_attr_e('To','touroperatorpro');?></label>
            <input type="text" name="datetimes" />
        </div>
        <div class="block-sorting-dropdown">
            <div class="dropdown">
                <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:;">
                    <label><?php esc_attr_e('Advance','touroperatorpro');?></label>
                    <span>
                        <span><?php esc_attr_e('More option','touroperatorpro');?></span>
                        <i class="fas fa-sort-down"></i>
                    </span>
                </a>
                <div class="dropdown-menu">
                    <div class="block-filter-price block-filter-price-more-option">
                        <h5><?php esc_attr_e('Filter price','touroperatorpro');?></h5>
                        <input type="text" id="amount_1" readonly/>
                        <div id="slider-container-1"></div>
                        <input type="hidden" name="price_search">
                    </div>
                    <div class="block-tour-categories">
                        <h5><?php esc_attr_e('Tour type','touroperatorpro');?></h5>
                        <div class="block-tour-type-item">
                            <?php foreach ($list_tourtype as $tour_type) {?>
                                <label>
                                    <input type="checkbox" name="tour_type[]" value="<?php esc_attr_e($tour_type->id);?>"/>
                                    <span><?php esc_attr_e($tour_type->name);?></span>
                                </label>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <button class="btn btn-primary" type="submit"><?php esc_attr_e('Search','touroperatorpro');?></button>
        </div>
    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_search_tour/assets/less/block_search_tour.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-search-tour','block_search_tour',array(),'frontend/blocks/block_search_tour/assets/js/block_search_tour.js');



