<?php
namespace TourOperatorProBlock\block_search_tour;
use TourOperatorPro\Factory as FactoryAlias;
use TourOperatorPro\Mvc\Model\ModelList;
use TourOperatorPro\Utilities\Utility as UtilityAlias;
use TourOperatorProFrontend\app\helpers\DestinationHelper;

class block_search_tour_helper {
    public static function getList_destination(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('DISTINCT country.countryname, country.id')
            ->from(UtilityAlias::getTableName('country').' AS country ')
            ->leftJoin(UtilityAlias::getTableName('state').' AS state ON state.country_id=country.id')
            ->where('country.id=state.country_id')
            ->group('country.id')
        ;

        $list_country=$db->setQuery($query)->loadObjectList();

        foreach ($list_country as &$country) {
            $query->clear()
                ->select('location.name AS location_name, location.id AS location_id')
                ->from(UtilityAlias::getTableName('location').' AS location')
                ->leftJoin(UtilityAlias::getTableName('state'). ' AS state ON state.id=location.state_id')
                ->where('state.country_id='.(int)$country->id)
            ;
            $list_location = $db->setQuery($query)->loadObjectList();
            $country->list_location = $list_location;
        }

        return $list_country;
    }
    public static function getList_tourtype(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('tourtype.*')
            ->from(UtilityAlias::getTableName('tourtype').' AS tourtype ')
        ;

        $list_tourtype=$db->setQuery($query)->loadObjectList();
       return $list_tourtype;
    }
}