<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\Html\HtmlFrontend;

?>
<div class="block_recent_articles">
    <div class="contain">
        <div id="owl-carousel" class="owl-carousel owl-theme">
            <?php foreach ($list_articles as $item) { ?>
                <div class="list-articles">
                    <div class="item">
                        <img class="image lazy" data-src="<?php echo($item->image); ?> ">
                    </div>
                    <p class="name-articles">
                        <a href="<?php echo($item->guid) ?>"><?php echo ($item->post_title); ?></a>
                    </p>
                    <p class="date"><?php esc_html_e(HtmlFrontend::render_date($item->post_date)); ?></p>

                </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_recent_articles/assets/less/block_recent_articles.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block_recent_articles','block_recent_articles',array(),'frontend/blocks/block_recent_articles/assets/js/block_recent_articles.js');