<?php
namespace TourOperatorProBlock\block_recent_articles;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use TourOperatorPro\Factory;
use TourOperatorPro\Mvc\Model\Model;
use TourOperatorPro\Wordpress\TBPRO_Widget_Base;
use TourOperatorPro\Wordpress\TBPRO_Widget_Base_Interface;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class CategoriesWidget
 */
class recent_articlesWidget  extends TBPRO_Widget_Base
{

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    public function get_name() {

        return  "recent_articles";
    }
    public function get_title() {

        return  "Recent Articles";
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html('Content', 'touroperatorpro' ),
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => esc_html('Style', 'touroperatorpro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'home-1',
                'options' => [
                    'home-1' => 'Home 1',
                    'home-2' => 'Home 2',
                    'home-3' => 'Home 3',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_control(
            'read_more_text',
            [
                'label' => esc_html('Text Read More', 'touroperatorpro' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_attr('', 'touroperatorpro' ),
                'default' => esc_attr('Read_Article', 'touroperatorpro' ),
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html('Style', 'touroperatorpro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->end_controls_section();
    }


    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return [ 'touroperatorpro' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    public function get_data_config($settings) {
        $data_setting=new \stdClass();
        $data_setting->read_more_text=$settings['read_more_text'];
        $data_setting->style=$settings['style'];
        return $data_setting;
    }


}
