<?php

use TourOperatorPro\Factory;
use TourOperatorPro\Language\Text;
use TourOperatorProFrontend\app\helpers\CurrencyHelper;
use TourOperatorProFrontend\app\helpers\FrontendHelper;

$tour = $this->tour;
$new_price = $tour ->price;
if($tour->discount) {
    if($tour->discount->amount > 0) {
        $new_price = $tour->price - $tour->discount->amount;
    } else if ($tour->discount->percent > 0) {
        $new_price= $tour->price - ($tour->price * $tour->discount->percent) / 100 ;
    }
}
$max_star = 5;
$tour_rating=$tour->rating;
while ($tour_rating > $max_star) {
    $tour_rating = $tour_rating - $max_star;
}
$star = $tour_rating % 10;
$non_star = ($max_star - $tour_rating) % 10;
$half_star = ceil($max_star-$star-$non_star);
?>
<div class="row">
    <div class="col-md-12">
        <div class="block-tour-item-display-list">
            <div class="block-info-content">
                <div class="img-block">
                    <div>
                        <img src="<?php echo (Factory::getRootUrlPlugin());?><?php echo ($tour->image);?>" >
                    </div>
                </div>
                <div class="block-feature">
                    <div class="label-feature <?php Text::_echo_no_translate($tour->is_feature == 1?'visible':'');?>">
                        <span><?php esc_attr_e('Featured','touroperatorpro');?></span>
                    </div>
                    <i class="fas fa-heart"></i>
                </div>
            </div>
            <div class="content-infor-tour">
                <p class="place-tour">
                    <i class="icon-nb-pin"></i>
                    <span>
                        <?php
                        if(isset(end($tour->list_destination)->address)){
                            echo (end($tour->list_destination)->address);
                        }
                        ?>
                    </span>
                </p>
                <h4 class="name-tour">
                    <a href="<?php echo ($this->page_tour_detail.'?tour_id='.$tour->id); ?>">
                        <?php echo ($tour->name);?>
                    </a>
                </h4>
                <div class="block-rating">
                    <ul class="list-rating-star">
                        <?php if($tour->rating > 0) {?>
                            <?php for ($i=0; $i <$star; $i++) {?>
                                <li class="item-star"><i class="fas fa-star"></i></li>
                            <?php }?>
                            <?php for ($i=0; $i <$half_star; $i++) {?>
                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                            <?php }?>
                            <?php for ($i=0; $i <$non_star; $i++) {?>
                                <li class="item-star"><i class="far fa-star"></i></li>
                            <?php }?>
                        <?php }?>
                    </ul>
                    <div class="rating-review">
                        <span>2 Reviews</span>
                    </div>
                </div>
                <div class="description">
                    <?php echo ($tour->description);?>
                </div>
            </div>
            <div class="content-right">
                <?php if($tour->discount) {?>
                    <?php if($tour->discount->amount > 0) {?>>
                        <span class="box-sale">- $<?php echo ($tour->discount->amount);?></span>
                    <?php } if($tour->discount->percent > 0) {?>
                        <span class="box-sale"><?php echo ($tour->discount->percent);?>%</span>
                    <?php }?>
                <?php }?>
                <div class="price-tour">
                    <p class="old-price">
                        <?php if($tour->discount) {?>
                            <span><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$tour->price)));?></span>
                        <?php } else {?>
                            <span></span>
                        <?php }?>
                    </p>
                    <p class="new-price">
                        <span><i class="fas fa-bolt"></i><span>from</span></span>
                        <span class="price"><?php esc_html_e(CurrencyHelper::convertSymbols(CurrencyHelper::convertCurrencyFront((float)$new_price)));?></span>
                    </p>
                </div>
                <div class="trip-time">
                    <i class="icon-nb-clock"></i>
                    <span><?php echo ($tour->duration);?> <?php esc_attr_e('Days','touroperatorpro');?></span>
                </div>
                <div class="tour-type-detail">
                        <i class="fas fa-shoe-prints"></i>
                        <span>
                            <?php echo (implode(', ', array_map(function ($v){return $v->name;},$tour->list_tour_type)))?>
                        </span>
                </div>
                <div class="view-more">
                    <a href="<?php echo ($this->page_tour_detail.'?tour_id='.$tour->id); ?>" class="btn btn-primary"><?php esc_attr_e('View tour','touroperatorpro');?></a>
                </div>
            </div>
        </div>
    </div>
</div>
